/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.abicheck.collector;

import com.yahoo.abicheck.collector.Util;
import com.yahoo.abicheck.signature.JavaClassSignature;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class PublicSignatureCollector
extends ClassVisitor {
    private final Map<String, JavaClassSignature> classSignatures = new LinkedHashMap<String, JavaClassSignature>();
    private String currentName;
    private String currentSuper;
    private Set<String> currentInterfaces;
    private int currentAccess;
    private Set<String> currentMethods;
    private Set<String> currentFields;

    public PublicSignatureCollector() {
        super(589824);
    }

    private static boolean testBit(long access, long mask) {
        return (access & mask) != 0L;
    }

    private static String describeMethod(String name, int access, String returnType, List<String> argumentTypes) {
        return String.format("%s %s %s(%s)", PublicSignatureCollector.describeAccess(access, Util.methodFlags), returnType, name, String.join((CharSequence)", ", argumentTypes));
    }

    private static String describeAccess(int access, List<Util.AccessFlag> possibleFlags) {
        return String.join((CharSequence)" ", Util.convertAccess(access, possibleFlags));
    }

    private static String describeField(String name, int access, String type) {
        return String.format("%s %s %s", PublicSignatureCollector.describeAccess(access, Util.fieldFlags), type, name);
    }

    private static String internalNameToClassName(String superName) {
        return Type.getObjectType((String)superName).getClassName();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.currentName = PublicSignatureCollector.internalNameToClassName(name);
        this.currentSuper = PublicSignatureCollector.internalNameToClassName(superName);
        this.currentInterfaces = Arrays.stream(interfaces).map(PublicSignatureCollector::internalNameToClassName).collect(Collectors.toCollection(LinkedHashSet::new));
        this.currentAccess = access;
        this.currentMethods = new LinkedHashSet<String>();
        this.currentFields = new LinkedHashSet<String>();
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.isVisibleMember(access)) {
            Type method = Type.getMethodType((String)descriptor);
            List<String> argumentTypes = Arrays.stream(method.getArgumentTypes()).map(Type::getClassName).toList();
            this.currentMethods.add(PublicSignatureCollector.describeMethod(name, access, method.getReturnType().getClassName(), argumentTypes));
        }
        return null;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        if (this.isVisibleMember(access)) {
            this.currentFields.add(PublicSignatureCollector.describeField(name, access, Type.getType((String)descriptor).getClassName()));
        }
        return null;
    }

    private boolean isVisibleMember(int access) {
        if (PublicSignatureCollector.testBit(access, 1L)) {
            return true;
        }
        return PublicSignatureCollector.testBit(access, 4L) && !PublicSignatureCollector.testBit(this.currentAccess, 16L);
    }

    public void visitEnd() {
        if ((this.currentAccess & 1) != 0) {
            this.classSignatures.put(this.currentName, new JavaClassSignature(this.currentSuper, this.currentInterfaces, Util.convertAccess(this.currentAccess, Util.classFlags), this.currentMethods, this.currentFields));
        }
    }

    public Map<String, JavaClassSignature> getClassSignatures() {
        return this.classSignatures;
    }
}

