/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.abicheck.setmatcher;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SetMatcher {
    public static <T> boolean compare(Set<T> expected, Set<T> actual, Predicate<T> itemsMatch, Consumer<T> onMissing, Consumer<T> onExtra) {
        boolean mismatch = false;
        Sets.SetView missing = Sets.difference(expected, actual);
        for (Object item : missing) {
            mismatch = true;
            onMissing.accept(item);
        }
        Sets.SetView extra = Sets.difference(actual, expected);
        for (Object item : extra) {
            mismatch = true;
            onExtra.accept(item);
        }
        Sets.SetView both = Sets.intersection(actual, expected);
        for (Object item : both) {
            if (itemsMatch.test(item)) continue;
            mismatch = true;
        }
        return !mismatch;
    }
}

