/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.Properties;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.admin.internal.BaseResource;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import com.yahoo.pulsar.common.policies.data.PropertyAdmin;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;

public class PropertiesImpl
extends BaseResource
implements Properties {
    private final WebTarget properties;

    public PropertiesImpl(WebTarget web, Authentication auth) {
        super(auth);
        this.properties = web.path("/properties");
    }

    @Override
    public List<String> getProperties() throws PulsarAdminException {
        try {
            return (List)this.request(this.properties).get((GenericType)new GenericType<List<String>>(){});
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public PropertyAdmin getPropertyAdmin(String property) throws PulsarAdminException {
        try {
            return (PropertyAdmin)this.request(this.properties.path(property)).get(PropertyAdmin.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createProperty(String property, PropertyAdmin config) throws PulsarAdminException {
        try {
            this.request(this.properties.path(property)).put(Entity.entity((Object)config, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void updateProperty(String property, PropertyAdmin config) throws PulsarAdminException {
        try {
            this.request(this.properties.path(property)).post(Entity.entity((Object)config, (String)"application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteProperty(String property) throws PulsarAdminException {
        try {
            this.request(this.properties.path(property)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    public WebTarget getWebTarget() {
        return this.properties;
    }
}

