/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin.internal;

import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.client.util.FutureUtil;
import com.yahoo.pulsar.common.policies.data.ErrorData;
import java.net.ConnectException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.client.WebTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResource {
    private static final Logger log = LoggerFactory.getLogger(BaseResource.class);
    private final Authentication auth;

    protected BaseResource(Authentication auth) {
        this.auth = auth;
    }

    public Invocation.Builder request(WebTarget target) throws PulsarAdminException {
        try {
            Invocation.Builder builder = target.request(new String[]{"application/json"});
            if (this.auth != null && this.auth.getAuthData().hasDataForHttp()) {
                for (Map.Entry header : this.auth.getAuthData().getHttpHeaders()) {
                    builder.header((String)header.getKey(), header.getValue());
                }
            }
            return builder;
        }
        catch (Throwable t) {
            throw new PulsarAdminException.GettingAuthenticationDataException(t);
        }
    }

    public <T> CompletableFuture<Void> asyncPutRequest(final WebTarget target, Entity<T> entity) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().put(entity, (InvocationCallback)new InvocationCallback<ErrorData>(){

                public void completed(ErrorData response) {
                    future.complete(null);
                }

                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http put request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> CompletableFuture<Void> asyncPostRequest(final WebTarget target, Entity<T> entity) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().post(entity, (InvocationCallback)new InvocationCallback<ErrorData>(){

                public void completed(ErrorData response) {
                    future.complete(null);
                }

                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public <T> Future<T> asyncGetRequest(WebTarget target, InvocationCallback<T> callback) {
        try {
            return this.request(target).async().get(callback);
        }
        catch (PulsarAdminException cae) {
            return FutureUtil.failedFuture((Throwable)cae);
        }
    }

    public CompletableFuture<Void> asyncDeleteRequest(final WebTarget target) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(target).async().delete((InvocationCallback)new InvocationCallback<ErrorData>(){

                public void completed(ErrorData response) {
                    future.complete(null);
                }

                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http delete request: {}", (Object)target.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.this.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public PulsarAdminException getApiException(Throwable e) {
        if (e instanceof ServiceUnavailableException) {
            if (e.getCause() instanceof ConnectException) {
                return new PulsarAdminException.ConnectException(e.getCause());
            }
            return new PulsarAdminException.HttpErrorException(e);
        }
        if (e instanceof WebApplicationException) {
            if (e instanceof ServerErrorException) {
                ServerErrorException see = (ServerErrorException)e;
                return new PulsarAdminException.ServerSideErrorException(see);
            }
            ClientErrorException cee = (ClientErrorException)e;
            int statusCode = cee.getResponse().getStatus();
            switch (statusCode) {
                case 401: 
                case 403: {
                    return new PulsarAdminException.NotAuthorizedException(cee);
                }
                case 404: {
                    return new PulsarAdminException.NotFoundException(cee);
                }
                case 405: {
                    return new PulsarAdminException.NotAllowedException(cee);
                }
                case 409: {
                    return new PulsarAdminException.ConflictException(cee);
                }
                case 412: {
                    return new PulsarAdminException.PreconditionFailedException(cee);
                }
            }
            return new PulsarAdminException(cee);
        }
        return new PulsarAdminException(e);
    }
}

