/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin;

import com.yahoo.pulsar.client.admin.BrokerStats;
import com.yahoo.pulsar.client.admin.Brokers;
import com.yahoo.pulsar.client.admin.Clusters;
import com.yahoo.pulsar.client.admin.Lookup;
import com.yahoo.pulsar.client.admin.Namespaces;
import com.yahoo.pulsar.client.admin.PersistentTopics;
import com.yahoo.pulsar.client.admin.Properties;
import com.yahoo.pulsar.client.admin.ResourceQuotas;
import com.yahoo.pulsar.client.admin.internal.BrokerStatsImpl;
import com.yahoo.pulsar.client.admin.internal.BrokersImpl;
import com.yahoo.pulsar.client.admin.internal.ClustersImpl;
import com.yahoo.pulsar.client.admin.internal.JacksonConfigurator;
import com.yahoo.pulsar.client.admin.internal.LookupImpl;
import com.yahoo.pulsar.client.admin.internal.NamespacesImpl;
import com.yahoo.pulsar.client.admin.internal.PersistentTopicsImpl;
import com.yahoo.pulsar.client.admin.internal.PropertiesImpl;
import com.yahoo.pulsar.client.admin.internal.ResourceQuotasImpl;
import com.yahoo.pulsar.client.api.Authentication;
import com.yahoo.pulsar.client.api.AuthenticationDataProvider;
import com.yahoo.pulsar.client.api.AuthenticationFactory;
import com.yahoo.pulsar.client.api.ClientConfiguration;
import com.yahoo.pulsar.client.api.PulsarClientException;
import com.yahoo.pulsar.client.impl.auth.AuthenticationDisabled;
import com.yahoo.pulsar.common.util.SecurityUtility;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class PulsarAdmin
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(PulsarAdmin.class);
    private final Clusters clusters;
    private final Brokers brokers;
    private final BrokerStats brokerStats;
    private final Properties properties;
    private final Namespaces namespaces;
    private final PersistentTopics persistentTopics;
    private final ResourceQuotas resourceQuotas;
    private final Client client;
    private final URL serviceUrl;
    private final WebTarget web;
    private final Lookup lookups;
    private final Authentication auth;

    public PulsarAdmin(URL serviceUrl, ClientConfiguration pulsarConfig) throws PulsarClientException {
        this.auth = pulsarConfig != null ? pulsarConfig.getAuthentication() : new AuthenticationDisabled();
        LOG.debug("created: serviceUrl={}, authMethodName={}", (Object)serviceUrl, this.auth != null ? this.auth.getAuthMethodName() : null);
        if (this.auth != null) {
            this.auth.start();
        }
        ClientConfig httpConfig = new ClientConfig();
        httpConfig.property("jersey.config.client.followRedirects", (Object)true);
        httpConfig.property("jersey.config.client.async.threadPoolSize", (Object)8);
        ClientBuilder clientBuilder = (ClientBuilder)((ClientBuilder)ClientBuilder.newBuilder().withConfig((Configuration)httpConfig).register(JacksonConfigurator.class)).register(JacksonFeature.class);
        if (pulsarConfig != null && pulsarConfig.isUseTls()) {
            try {
                SSLContext sslCtx = null;
                Certificate[] trustCertificates = SecurityUtility.loadCertificatesFromPemFile((String)pulsarConfig.getTlsTrustCertsFilePath());
                AuthenticationDataProvider authData = this.auth.getAuthData();
                sslCtx = authData.hasDataForTls() ? SecurityUtility.createSslContext((boolean)pulsarConfig.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates, (Certificate[])authData.getTlsCertificates(), (PrivateKey)authData.getTlsPrivateKey()) : SecurityUtility.createSslContext((boolean)pulsarConfig.isTlsAllowInsecureConnection(), (Certificate[])trustCertificates);
                clientBuilder.sslContext(sslCtx);
            }
            catch (Exception e) {
                try {
                    if (this.auth != null) {
                        this.auth.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.error("Failed to close the authentication service", (Throwable)ioe);
                }
                throw new PulsarClientException.InvalidConfigurationException(e.getMessage());
            }
        }
        this.client = clientBuilder.build();
        this.serviceUrl = serviceUrl;
        WebTarget root = this.client.target(serviceUrl.toString());
        this.web = root.path("/admin");
        this.clusters = new ClustersImpl(this.web, this.auth);
        this.brokers = new BrokersImpl(this.web, this.auth);
        this.brokerStats = new BrokerStatsImpl(this.web, this.auth);
        this.properties = new PropertiesImpl(this.web, this.auth);
        this.namespaces = new NamespacesImpl(this.web, this.auth);
        this.persistentTopics = new PersistentTopicsImpl(this.web, this.auth);
        this.resourceQuotas = new ResourceQuotasImpl(this.web, this.auth);
        this.lookups = new LookupImpl(root, this.auth, pulsarConfig.isUseTls());
    }

    public PulsarAdmin(URL serviceUrl, final Authentication auth) throws PulsarClientException {
        this(serviceUrl, new ClientConfiguration(){
            private static final long serialVersionUID = 1L;
            {
                this.setAuthentication(auth);
            }
        });
    }

    public PulsarAdmin(URL serviceUrl, String authPluginClassName, String authParamsString) throws PulsarClientException {
        this(serviceUrl, AuthenticationFactory.create((String)authPluginClassName, (String)authParamsString));
    }

    public PulsarAdmin(URL serviceUrl, String authPluginClassName, Map<String, String> authParams) throws PulsarClientException {
        this(serviceUrl, AuthenticationFactory.create((String)authPluginClassName, authParams));
    }

    public Clusters clusters() {
        return this.clusters;
    }

    public Brokers brokers() {
        return this.brokers;
    }

    public Properties properties() {
        return this.properties;
    }

    public Namespaces namespaces() {
        return this.namespaces;
    }

    public PersistentTopics persistentTopics() {
        return this.persistentTopics;
    }

    public ResourceQuotas resourceQuotas() {
        return this.resourceQuotas;
    }

    public Lookup lookups() {
        return this.lookups;
    }

    public BrokerStats brokerStats() {
        return this.brokerStats;
    }

    public URL getServiceUrl() {
        return this.serviceUrl;
    }

    @Override
    public void close() {
        try {
            if (this.auth != null) {
                this.auth.close();
            }
        }
        catch (IOException e) {
            LOG.error("Failed to close the authentication service", (Throwable)e);
        }
        this.client.close();
    }

    static {
        try {
            Class.forName("org.slf4j.impl.JDK14LoggerFactory");
        }
        catch (Exception ex) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
        }
    }
}

