/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.pulsar.client.admin;

import com.google.gson.JsonObject;
import com.yahoo.pulsar.client.admin.PulsarAdminException;
import com.yahoo.pulsar.client.api.Message;
import com.yahoo.pulsar.client.api.MessageId;
import com.yahoo.pulsar.common.partition.PartitionedTopicMetadata;
import com.yahoo.pulsar.common.policies.data.AuthAction;
import com.yahoo.pulsar.common.policies.data.PartitionedTopicStats;
import com.yahoo.pulsar.common.policies.data.PersistentTopicInternalStats;
import com.yahoo.pulsar.common.policies.data.PersistentTopicStats;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface PersistentTopics {
    public List<String> getList(String var1) throws PulsarAdminException;

    public List<String> getPartitionedTopicList(String var1) throws PulsarAdminException;

    public Map<String, Set<AuthAction>> getPermissions(String var1) throws PulsarAdminException;

    public void grantPermission(String var1, String var2, Set<AuthAction> var3) throws PulsarAdminException;

    public void revokePermissions(String var1, String var2) throws PulsarAdminException;

    public void createPartitionedTopic(String var1, int var2) throws PulsarAdminException;

    public CompletableFuture<Void> createPartitionedTopicAsync(String var1, int var2);

    public void updatePartitionedTopic(String var1, int var2) throws PulsarAdminException;

    public CompletableFuture<Void> updatePartitionedTopicAsync(String var1, int var2);

    public PartitionedTopicMetadata getPartitionedTopicMetadata(String var1) throws PulsarAdminException;

    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(String var1);

    public void deletePartitionedTopic(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> deletePartitionedTopicAsync(String var1);

    public void delete(String var1) throws PulsarAdminException;

    public CompletableFuture<Void> deleteAsync(String var1);

    public CompletableFuture<MessageId> terminateTopicAsync(String var1);

    public List<String> getSubscriptions(String var1) throws PulsarAdminException;

    public CompletableFuture<List<String>> getSubscriptionsAsync(String var1);

    public PersistentTopicStats getStats(String var1) throws PulsarAdminException;

    public CompletableFuture<PersistentTopicStats> getStatsAsync(String var1);

    public PersistentTopicInternalStats getInternalStats(String var1) throws PulsarAdminException;

    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String var1);

    public JsonObject getInternalInfo(String var1) throws PulsarAdminException;

    public CompletableFuture<JsonObject> getInternalInfoAsync(String var1);

    public PartitionedTopicStats getPartitionedStats(String var1, boolean var2) throws PulsarAdminException;

    public CompletableFuture<PartitionedTopicStats> getPartitionedStatsAsync(String var1, boolean var2);

    public void deleteSubscription(String var1, String var2) throws PulsarAdminException;

    public CompletableFuture<Void> deleteSubscriptionAsync(String var1, String var2);

    public void skipAllMessages(String var1, String var2) throws PulsarAdminException;

    public CompletableFuture<Void> skipAllMessagesAsync(String var1, String var2);

    public void skipMessages(String var1, String var2, long var3) throws PulsarAdminException;

    public CompletableFuture<Void> skipMessagesAsync(String var1, String var2, long var3);

    public void expireMessages(String var1, String var2, long var3) throws PulsarAdminException;

    public CompletableFuture<Void> expireMessagesAsync(String var1, String var2, long var3);

    public void expireMessagesForAllSubscriptions(String var1, long var2) throws PulsarAdminException;

    public CompletableFuture<Void> expireMessagesForAllSubscriptionsAsync(String var1, long var2);

    public List<Message> peekMessages(String var1, String var2, int var3) throws PulsarAdminException;

    public CompletableFuture<List<Message>> peekMessagesAsync(String var1, String var2, int var3);

    public void resetCursor(String var1, String var2, long var3) throws PulsarAdminException;

    public CompletableFuture<Void> resetCursorAsync(String var1, String var2, long var3);
}

