/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.validator;

import com.yahoo.elide.core.utils.ClassScanner;
import com.yahoo.elide.datastores.aggregation.DefaultQueryValidator;
import com.yahoo.elide.datastores.aggregation.metadata.FormulaValidator;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.models.Column;
import com.yahoo.elide.datastores.aggregation.query.ColumnProjection;
import com.yahoo.elide.datastores.aggregation.query.DefaultQueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.Optimizer;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.SQLQueryEngine;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import com.yahoo.elide.datastores.aggregation.validator.ColumnArgumentValidator;
import com.yahoo.elide.datastores.aggregation.validator.TableArgumentValidator;
import com.yahoo.elide.modelconfig.store.models.ConfigFile;
import com.yahoo.elide.modelconfig.validator.DynamicConfigValidator;
import com.yahoo.elide.modelconfig.validator.Validator;
import java.util.HashSet;
import java.util.Map;

public class TemplateConfigValidator
implements Validator {
    private final ClassScanner scanner;
    private final String configRoot;

    public TemplateConfigValidator(ClassScanner scanner, String configRoot) {
        this.scanner = scanner;
        this.configRoot = configRoot;
    }

    MetaDataStore rebuildMetaDataStore(Map<String, ConfigFile> resourceMap) {
        DynamicConfigValidator validator = new DynamicConfigValidator(this.scanner, this.configRoot);
        validator.validate(resourceMap);
        MetaDataStore metaDataStore = new MetaDataStore(this.scanner, validator.getTables(), validator.getNamespaceConfigurations(), false);
        new SQLQueryEngine(metaDataStore, unused -> null, new HashSet<Optimizer>(), new DefaultQueryPlanMerger(metaDataStore), new DefaultQueryValidator(metaDataStore.getMetadataDictionary()));
        return metaDataStore;
    }

    public void validate(Map<String, ConfigFile> resourceMap) {
        MetaDataStore metaDataStore = this.rebuildMetaDataStore(resourceMap);
        metaDataStore.getTables().forEach(table -> {
            SQLTable sqlTable = (SQLTable)table;
            this.checkForCycles(sqlTable, metaDataStore);
            TableArgumentValidator tableArgValidator = new TableArgumentValidator(metaDataStore, sqlTable);
            tableArgValidator.validate();
            sqlTable.getAllColumns().forEach(column -> {
                ColumnArgumentValidator colArgValidator = new ColumnArgumentValidator(metaDataStore, sqlTable, (Column)column);
                colArgValidator.validate();
            });
        });
    }

    private void checkForCycles(SQLTable sqlTable, MetaDataStore metaDataStore) {
        FormulaValidator formulaValidator = new FormulaValidator(metaDataStore);
        sqlTable.getColumnProjections().forEach(column -> formulaValidator.parse((Queryable)sqlTable, (ColumnProjection)column));
    }
}

