/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.metadata.models;

import com.yahoo.elide.annotation.ApiVersion;
import com.yahoo.elide.annotation.ComputedRelationship;
import com.yahoo.elide.annotation.Exclude;
import com.yahoo.elide.annotation.Include;
import com.yahoo.elide.datastores.aggregation.dynamic.NamespacePackage;
import com.yahoo.elide.datastores.aggregation.metadata.models.Table;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@Include(name="namespace")
public class Namespace {
    @Id
    private final String id;
    private final String name;
    private final String friendlyName;
    private final String description;
    @Exclude
    private final String version;
    @Exclude
    private final NamespacePackage pkg;
    @Exclude
    private Set<Table> tables;

    @OneToMany
    @ComputedRelationship
    public Set<Table> getTables() {
        return this.tables.stream().filter(table -> !table.isHidden()).collect(Collectors.toSet());
    }

    public Namespace(NamespacePackage pkg) {
        this.pkg = pkg;
        this.id = this.name = pkg.getName().isEmpty() ? "default" : pkg.getName();
        this.tables = new HashSet<Table>();
        Include include = pkg.getDeclaredAnnotation(Include.class);
        if (include != null) {
            this.friendlyName = include.friendlyName() == null || include.friendlyName().isEmpty() ? this.name : include.friendlyName();
            this.description = include.description();
        } else {
            this.friendlyName = this.name;
            this.description = null;
        }
        ApiVersion apiVersion = pkg.getDeclaredAnnotation(ApiVersion.class);
        this.version = apiVersion == null ? "" : apiVersion.version();
    }

    public void addTable(Table table) {
        this.tables.add(table);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getVersion() {
        return this.version;
    }

    public NamespacePackage getPkg() {
        return this.pkg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$friendlyName = this.getFriendlyName();
        String other$friendlyName = other.getFriendlyName();
        if (this$friendlyName == null ? other$friendlyName != null : !this$friendlyName.equals(other$friendlyName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        NamespacePackage this$pkg = this.getPkg();
        NamespacePackage other$pkg = other.getPkg();
        return !(this$pkg == null ? other$pkg != null : !((Object)this$pkg).equals(other$pkg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Namespace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $friendlyName = this.getFriendlyName();
        result = result * 59 + ($friendlyName == null ? 43 : $friendlyName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        NamespacePackage $pkg = this.getPkg();
        result = result * 59 + ($pkg == null ? 43 : ((Object)$pkg).hashCode());
        return result;
    }

    public String toString() {
        return "Namespace(id=" + this.getId() + ", name=" + this.getName() + ", friendlyName=" + this.getFriendlyName() + ", description=" + this.getDescription() + ", version=" + this.getVersion() + ", pkg=" + this.getPkg() + ")";
    }
}

