/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite;

import com.yahoo.elide.datastores.aggregation.queryengines.sql.calcite.SupportedAggregation;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.dialects.SQLDialect;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;

public class CalciteInnerAggregationExtractor
extends SqlBasicVisitor<List<List<String>>> {
    private SQLDialect dialect;

    public CalciteInnerAggregationExtractor(SQLDialect dialect) {
        this.dialect = dialect;
    }

    public List<List<String>> visit(SqlCall call) {
        String operatorName = call.getOperator().getName();
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        SupportedAggregation operator = this.dialect.getSupportedAggregation(operatorName);
        if (operator != null) {
            List<String> operands = call.getOperandList().stream().map(operand -> operand.toSqlString(this.dialect.getCalciteDialect()).getSql()).collect(Collectors.toList());
            result.add(operator.getInnerAggregations(operands.toArray(new String[0])));
            return result;
        }
        for (SqlNode node : call.getOperandList()) {
            List operandResults;
            if (node == null || (operandResults = (List)node.accept((SqlVisitor)this)) == null) continue;
            result.addAll(operandResults);
        }
        return result;
    }

    public List<List<String>> visit(SqlNodeList nodeList) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        for (SqlNode node : nodeList) {
            List inner;
            if (node == null || (inner = (List)node.accept((SqlVisitor)this)) == null) continue;
            result.addAll(inner);
        }
        return result;
    }
}

