/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.core;

import com.yahoo.elide.core.Path;
import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.exceptions.InvalidValueException;
import com.yahoo.elide.core.request.Argument;
import com.yahoo.elide.core.type.ClassType;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class JoinPath
extends Path {
    private MetaDataStore store;

    public JoinPath(List<Path.PathElement> pathElements, MetaDataStore store) {
        super(pathElements);
        this.store = store;
    }

    public JoinPath(Type<?> entityClass, MetaDataStore store, String dotSeparatedPath) {
        this.store = store;
        this.pathElements = this.resolvePathElements(entityClass, store.getMetadataDictionary(), dotSeparatedPath);
    }

    protected boolean needNavigation(Type<?> entityClass, String fieldName, EntityDictionary dictionary) {
        return dictionary.isRelation(entityClass, fieldName) || SQLTable.isTableJoin(this.store, entityClass, fieldName);
    }

    public JoinPath extend(String extensionPath) {
        return JoinPath.extendJoinPath(this, new JoinPath(((Path.PathElement)this.lastElement().get()).getType(), this.store, extensionPath), this.store);
    }

    private static <P extends Path> JoinPath extendJoinPath(Path path, P extension, MetaDataStore store) {
        ArrayList<Path.PathElement> toExtend = new ArrayList<Path.PathElement>(path.getPathElements());
        toExtend.remove(toExtend.size() - 1);
        toExtend.addAll(extension.getPathElements());
        return new JoinPath(toExtend, store);
    }

    protected Path.PathElement resolvePathAttribute(Type<?> entityClass, String fieldName, String alias, Set<Argument> arguments, EntityDictionary dictionary) {
        ClassType attributeClass = ClassType.OBJECT_TYPE;
        if (dictionary.isAttribute(entityClass, fieldName) || fieldName.equals(dictionary.getIdFieldName(entityClass))) {
            attributeClass = dictionary.getType(entityClass, fieldName);
            return new Path.PathElement(entityClass, (Type)attributeClass, fieldName, alias, arguments);
        }
        if (fieldName.indexOf(36) == 0) {
            return new Path.PathElement(entityClass, (Type)attributeClass, fieldName, alias, arguments);
        }
        String entityAlias = dictionary.getJsonAliasFor(entityClass);
        throw new InvalidValueException((Object)(entityAlias + " does not contain the field " + fieldName));
    }
}

