/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.validator;

import com.yahoo.elide.core.dictionary.EntityDictionary;
import com.yahoo.elide.core.type.Type;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.metadata.models.ArgumentDefinition;
import com.yahoo.elide.datastores.aggregation.query.Queryable;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.ExpressionParser;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.expression.TableArgReference;
import com.yahoo.elide.datastores.aggregation.queryengines.sql.metadata.SQLTable;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TableArgumentValidator {
    private final MetaDataStore metaDataStore;
    private final SQLTable table;
    private final String errorMsgPrefix;
    private final ExpressionParser parser;
    private final EntityDictionary dictionary;

    public TableArgumentValidator(MetaDataStore metaDataStore, SQLTable table) {
        this.metaDataStore = metaDataStore;
        this.table = table;
        this.errorMsgPrefix = String.format("Failed to verify table arguments for table: %s. ", table.getName());
        this.parser = new ExpressionParser(metaDataStore);
        this.dictionary = metaDataStore.getMetadataDictionary();
    }

    public void validate() {
        this.table.getArgumentDefinitions().forEach(arg -> {
            TableArgumentValidator.verifyValues(arg, this.errorMsgPrefix);
            TableArgumentValidator.verifyDefaultValue(arg, this.errorMsgPrefix);
        });
        this.verifyTableArgsInTableSql();
        this.verifyTableArgsInColumnDefinition();
        this.verifyTableArgsInJoinExpressions();
        this.verifyRequiredTableArgsForJoinTables();
    }

    private void verifyTableArgsInTableSql() {
        Type tableClass = this.dictionary.getEntityClass(this.table.getName(), this.table.getVersion());
        if (SQLTable.hasSql(tableClass)) {
            String selectSql = SQLTable.resolveTableOrSubselect(this.dictionary, tableClass);
            this.verifyTableArgsExists(selectSql, "in table's sql.");
        }
    }

    private void verifyTableArgsInColumnDefinition() {
        this.table.getColumnProjections().forEach(column -> this.verifyTableArgsExists(column.getExpression(), String.format("in definition of column: '%s'.", column.getName())));
    }

    private void verifyTableArgsInJoinExpressions() {
        this.table.getJoins().forEach((joinName, join) -> this.verifyTableArgsExists(join.getJoinExpression(), String.format("in definition of join: '%s'.", joinName)));
    }

    private void verifyTableArgsExists(String expression, String errorMsgSuffix) {
        this.parser.parse((Queryable)this.table, expression).stream().filter(ref -> ref instanceof TableArgReference).map(TableArgReference.class::cast).map(TableArgReference::getArgName).forEach(argName -> {
            if (!this.table.hasArgumentDefinition((String)argName) && !this.hasTemplateFilterArgument((String)argName)) {
                throw new IllegalStateException(String.format(this.errorMsgPrefix + "Argument '%s' is not defined but found '{{$$table.args.%s}}' " + errorMsgSuffix, argName, argName));
            }
        });
    }

    private boolean hasTemplateFilterArgument(String argName) {
        return this.table.getRequiredFilter() != null && this.table.getRequiredFilter().contains("{{" + argName + "}}");
    }

    private void verifyRequiredTableArgsForJoinTables() {
        this.table.getJoins().forEach((joinName, sqlJoin) -> {
            SQLTable joinTable = (SQLTable)this.metaDataStore.getTable(sqlJoin.getJoinTableType());
            joinTable.getArgumentDefinitions().forEach(joinArgDef -> {
                String joinArgName = joinArgDef.getName();
                if (this.table.hasArgumentDefinition(joinArgName)) {
                    if (joinArgDef.getType() != this.table.getArgumentDefinition(joinArgName).getType()) {
                        throw new IllegalStateException(String.format(this.errorMsgPrefix + "Argument type mismatch. Join table: '%s' has same Argument: '%s' with type '%s'.", new Object[]{joinTable.getName(), joinArgName, joinArgDef.getType()}));
                    }
                } else if (StringUtils.isBlank((CharSequence)joinArgDef.getDefaultValue().toString())) {
                    throw new IllegalStateException(String.format(this.errorMsgPrefix + "Argument '%s' with type '%s' is not defined but is required by join table: %s.", new Object[]{joinArgName, joinArgDef.getType(), joinTable.getName()}));
                }
            });
        });
    }

    public static void verifyValues(ArgumentDefinition argument, String errorMsgPrefix) {
        Set<String> values = argument.getValues();
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        values.forEach(value -> {
            if (!argument.getType().matches((String)value)) {
                throw new IllegalStateException(String.format(errorMsgPrefix + "Value: '%s' for Argument '%s' with Type '%s' is invalid.", new Object[]{value, argument.getName(), argument.getType()}));
            }
        });
    }

    public static void verifyDefaultValue(ArgumentDefinition argument, String errorMsgPrefix) {
        Object value = argument.getDefaultValue();
        if (value == null) {
            throw new IllegalStateException(String.format("Argument '%s' is missing a default value", argument.getName()));
        }
        String defaultValue = value.toString();
        TableArgumentValidator.verifyValue(argument, defaultValue, errorMsgPrefix + "Default ");
    }

    public static void verifyValue(ArgumentDefinition argument, String value, String errorMsgPrefix) {
        Set<String> values = argument.getValues();
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (CollectionUtils.isEmpty(values)) {
            if (!argument.getType().matches(value)) {
                throw new IllegalStateException(String.format(errorMsgPrefix + "Value: '%s' for Argument '%s' with Type '%s' is invalid.", new Object[]{value, argument.getName(), argument.getType()}));
            }
        } else if (!values.contains(value)) {
            throw new IllegalStateException(String.format(errorMsgPrefix + "Value: '%s' for Argument '%s' with Type '%s' must match one of these values: %s.", new Object[]{value, argument.getName(), argument.getType(), values}));
        }
    }
}

