/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.elide.datastores.aggregation.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.yahoo.elide.core.filter.expression.FilterExpression;
import com.yahoo.elide.datastores.aggregation.metadata.MetaDataStore;
import com.yahoo.elide.datastores.aggregation.query.DimensionProjection;
import com.yahoo.elide.datastores.aggregation.query.MetricProjection;
import com.yahoo.elide.datastores.aggregation.query.QueryPlan;
import com.yahoo.elide.datastores.aggregation.query.QueryPlanMerger;
import com.yahoo.elide.datastores.aggregation.query.TimeDimensionProjection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DefaultQueryPlanMerger
implements QueryPlanMerger {
    MetaDataStore metaDataStore;

    public DefaultQueryPlanMerger(MetaDataStore metaDataStore) {
        this.metaDataStore = metaDataStore;
    }

    @Override
    public boolean canMerge(QueryPlan a, QueryPlan b) {
        boolean result;
        Preconditions.checkNotNull((Object)a);
        Preconditions.checkNotNull((Object)b);
        if (a.nestDepth() != b.nestDepth()) {
            if (a.nestDepth() > b.nestDepth() && !b.canNest(this.metaDataStore)) {
                return false;
            }
            if (b.nestDepth() > a.nestDepth() && !a.canNest(this.metaDataStore)) {
                return false;
            }
            a = this.nestToDepth(a, b.nestDepth());
            b = this.nestToDepth(b, a.nestDepth());
        }
        if (!(result = this.canMergeMetrics(a, b))) {
            return false;
        }
        result = this.canMergeFilter(a, b);
        if (!result) {
            return false;
        }
        result = this.canMergeDimensions(a, b);
        if (!result) {
            return false;
        }
        result = this.canMergeTimeDimensions(a, b);
        if (!result) {
            return false;
        }
        if (a.isNested()) {
            result = this.canMerge((QueryPlan)a.getSource(), (QueryPlan)b.getSource());
        }
        return result;
    }

    protected boolean canMergeMetrics(QueryPlan a, QueryPlan b) {
        return true;
    }

    protected boolean canMergeDimensions(QueryPlan a, QueryPlan b) {
        for (DimensionProjection dimension : a.getDimensionProjections()) {
            DimensionProjection otherDimension = b.getDimensionProjection(dimension.getName());
            if (otherDimension == null || Objects.equals(otherDimension.getArguments(), dimension.getArguments())) continue;
            return false;
        }
        return true;
    }

    protected boolean canMergeTimeDimensions(QueryPlan a, QueryPlan b) {
        for (TimeDimensionProjection dimension : a.getTimeDimensionProjections()) {
            TimeDimensionProjection otherDimension = b.getTimeDimensionProjection(dimension.getName());
            if (otherDimension == null || Objects.equals(otherDimension.getArguments(), dimension.getArguments())) continue;
            return false;
        }
        return true;
    }

    protected boolean canMergeFilter(QueryPlan a, QueryPlan b) {
        return Objects.equals(a.getWhereFilter(), b.getWhereFilter());
    }

    protected FilterExpression mergeFilter(QueryPlan a, QueryPlan b) {
        return a.getWhereFilter();
    }

    protected Set<MetricProjection> mergeMetrics(QueryPlan a, QueryPlan b) {
        return Streams.concat((Stream[])new Stream[]{b.getMetricProjections().stream(), a.getMetricProjections().stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected Set<DimensionProjection> mergeDimension(QueryPlan a, QueryPlan b) {
        return Streams.concat((Stream[])new Stream[]{b.getDimensionProjections().stream(), a.getDimensionProjections().stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected Set<TimeDimensionProjection> mergeTimeDimension(QueryPlan a, QueryPlan b) {
        return Streams.concat((Stream[])new Stream[]{b.getTimeDimensionProjections().stream(), a.getTimeDimensionProjections().stream()}).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public QueryPlan merge(QueryPlan a, QueryPlan b) {
        Preconditions.checkNotNull((Object)a);
        Preconditions.checkNotNull((Object)b);
        a = this.nestToDepth(a, b.nestDepth());
        b = this.nestToDepth(b, a.nestDepth());
        assert (a.isNested() || a.getSource().equals(b.getSource()));
        Set<MetricProjection> metrics = this.mergeMetrics(a, b);
        Set<TimeDimensionProjection> timeDimensions = this.mergeTimeDimension(a, b);
        Set<DimensionProjection> dimensions = this.mergeDimension(a, b);
        if (!a.isNested()) {
            return QueryPlan.builder().source(a.getSource()).metricProjections(metrics).dimensionProjections(dimensions).whereFilter(this.mergeFilter(a, b)).timeDimensionProjections(timeDimensions).build();
        }
        QueryPlan mergedSource = this.merge((QueryPlan)a.getSource(), (QueryPlan)b.getSource());
        return QueryPlan.builder().source(mergedSource).metricProjections(metrics).dimensionProjections(dimensions).timeDimensionProjections(timeDimensions).build();
    }

    private QueryPlan nestToDepth(QueryPlan plan, int depth) {
        while (plan.nestDepth() < depth) {
            plan = plan.nest(this.metaDataStore);
        }
        return plan;
    }
}

