/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.JDK7Compatible;
import com.yahoo.memory.UnsafeUtil;

abstract class WritableMemoryImpl
extends BaseWritableMemoryImpl {
    WritableMemoryImpl(Object unsafeObj, long nativeBaseOffset, long regionOffset, long capacityBytes) {
        super(unsafeObj, nativeBaseOffset, regionOffset, capacityBytes);
    }

    @Override
    public char getChar(long offsetBytes) {
        return this.getNativeOrderedChar(offsetBytes);
    }

    @Override
    public void getCharArray(long offsetBytes, char[] dstArray, int dstOffsetChars, int lengthChars) {
        long copyBytes = (long)lengthChars << 1;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetChars, lengthChars, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + ((long)dstOffsetChars << 1), copyBytes);
    }

    @Override
    public double getDouble(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return UnsafeUtil.unsafe.getDouble(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public void getDoubleArray(long offsetBytes, double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long copyBytes = (long)lengthDoubles << 3;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetDoubles, lengthDoubles, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + ((long)dstOffsetDoubles << 3), copyBytes);
    }

    @Override
    public float getFloat(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return UnsafeUtil.unsafe.getFloat(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes));
    }

    @Override
    public void getFloatArray(long offsetBytes, float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long copyBytes = (long)lengthFloats << 2;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetFloats, lengthFloats, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + ((long)dstOffsetFloats << 2), copyBytes);
    }

    @Override
    public int getInt(long offsetBytes) {
        return this.getNativeOrderedInt(offsetBytes);
    }

    @Override
    public void getIntArray(long offsetBytes, int[] dstArray, int dstOffsetInts, int lengthInts) {
        long copyBytes = (long)lengthInts << 2;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetInts, lengthInts, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + ((long)dstOffsetInts << 2), copyBytes);
    }

    @Override
    public long getLong(long offsetBytes) {
        return this.getNativeOrderedLong(offsetBytes);
    }

    @Override
    public void getLongArray(long offsetBytes, long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long copyBytes = (long)lengthLongs << 3;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetLongs, lengthLongs, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + ((long)dstOffsetLongs << 3), copyBytes);
    }

    @Override
    public short getShort(long offsetBytes) {
        return this.getNativeOrderedShort(offsetBytes);
    }

    @Override
    public void getShortArray(long offsetBytes, short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long copyBytes = (long)lengthShorts << 1;
        this.checkValidAndBounds(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetShorts, lengthShorts, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), dstArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + ((long)dstOffsetShorts << 1), copyBytes);
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.putNativeOrderedChar(offsetBytes, value);
    }

    @Override
    public void putCharArray(long offsetBytes, char[] srcArray, int srcOffsetChars, int lengthChars) {
        long copyBytes = (long)lengthChars << 1;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetChars, lengthChars, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_CHAR_BASE_OFFSET + ((long)srcOffsetChars << 1), this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putDouble(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public void putDoubleArray(long offsetBytes, double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long copyBytes = (long)lengthDoubles << 3;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetDoubles, lengthDoubles, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_DOUBLE_BASE_OFFSET + ((long)srcOffsetDoubles << 3), this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putFloat(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), value);
    }

    @Override
    public void putFloatArray(long offsetBytes, float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long copyBytes = (long)lengthFloats << 2;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetFloats, lengthFloats, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_FLOAT_BASE_OFFSET + ((long)srcOffsetFloats << 2), this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.putNativeOrderedInt(offsetBytes, value);
    }

    @Override
    public void putIntArray(long offsetBytes, int[] srcArray, int srcOffsetInts, int lengthInts) {
        long copyBytes = (long)lengthInts << 2;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetInts, lengthInts, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_INT_BASE_OFFSET + ((long)srcOffsetInts << 2), this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.putNativeOrderedLong(offsetBytes, value);
    }

    @Override
    public void putLongArray(long offsetBytes, long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long copyBytes = (long)lengthLongs << 3;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetLongs, lengthLongs, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_LONG_BASE_OFFSET + ((long)srcOffsetLongs << 3), this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.putNativeOrderedShort(offsetBytes, value);
    }

    @Override
    public void putShortArray(long offsetBytes, short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long copyBytes = (long)lengthShorts << 1;
        this.checkValidAndBoundsForWrite(offsetBytes, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetShorts, lengthShorts, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_SHORT_BASE_OFFSET + ((long)srcOffsetShorts << 1), this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), copyBytes);
    }

    @Override
    public long getAndAddLong(long offsetBytes, long delta) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        long addr = this.getCumulativeOffset(offsetBytes);
        if (UnsafeUtil.JDK8_OR_ABOVE) {
            return UnsafeUtil.unsafe.getAndAddLong(this.getUnsafeObject(), addr, delta);
        }
        return JDK7Compatible.getAndAddLong(this.getUnsafeObject(), addr, delta);
    }

    @Override
    public long getAndSetLong(long offsetBytes, long newValue) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        long addr = this.getCumulativeOffset(offsetBytes);
        if (UnsafeUtil.JDK8_OR_ABOVE) {
            return UnsafeUtil.unsafe.getAndSetLong(this.getUnsafeObject(), addr, newValue);
        }
        return JDK7Compatible.getAndSetLong(this.getUnsafeObject(), addr, newValue);
    }

    @Override
    public boolean compareAndSwapLong(long offsetBytes, long expect, long update) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        return UnsafeUtil.unsafe.compareAndSwapLong(this.getUnsafeObject(), this.getCumulativeOffset(offsetBytes), expect, update);
    }
}

