/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.AccessByteBuffer;
import com.yahoo.memory.AllocateDirectMap;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.DefaultMemoryRequestServer;
import com.yahoo.memory.Memory;
import com.yahoo.memory.MemoryRequestServer;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.Util;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableDirectHandle;
import com.yahoo.memory.WritableHandle;
import com.yahoo.memory.WritableMapHandle;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class WritableMemory
extends Memory {
    public static WritableMemory wrap(ByteBuffer byteBuf) {
        if (byteBuf.isReadOnly()) {
            throw new ReadOnlyException("ByteBuffer is read-only.");
        }
        return WritableMemory.wrapBB(byteBuf, false);
    }

    static WritableMemory wrapBB(ByteBuffer byteBuf, boolean localReadOnly) {
        if (byteBuf.capacity() == 0) {
            return BaseWritableMemoryImpl.ZERO_SIZE_MEMORY;
        }
        ResourceState state = new ResourceState(byteBuf.isReadOnly());
        state.putByteBuffer(byteBuf);
        AccessByteBuffer.wrap(state);
        boolean ro = state.isResourceReadOnly() || localReadOnly;
        return BaseWritableMemoryImpl.newInstance(state, ro);
    }

    public static WritableMapHandle map(File file) throws IOException {
        return WritableMemory.map(file, 0L, file.length(), ByteOrder.nativeOrder());
    }

    public static WritableMapHandle map(File file, long fileOffsetBytes, long capacityBytes, ByteOrder byteOrder) throws IOException {
        Util.zeroCheck(capacityBytes, "Capacity");
        Util.nullCheck(file, "file is null");
        Util.negativeCheck(fileOffsetBytes, "File offset is negative");
        boolean rro = AllocateDirectMap.isFileReadOnly(file);
        if (rro) {
            throw new ReadOnlyException("Cannot map a read-only file into Writable Memory.");
        }
        ResourceState state = new ResourceState(rro);
        state.putCapacity(capacityBytes);
        state.putResourceOrder(byteOrder);
        return WritableMapHandle.map(state, file, fileOffsetBytes);
    }

    public static WritableDirectHandle allocateDirect(long capacityBytes) {
        if (capacityBytes == 0L) {
            return new WritableDirectHandle(null, BaseWritableMemoryImpl.ZERO_SIZE_MEMORY);
        }
        ResourceState state = new ResourceState(false);
        state.putCapacity(capacityBytes);
        WritableDirectHandle handle = WritableDirectHandle.allocateDirect(state);
        DefaultMemoryRequestServer server = new DefaultMemoryRequestServer();
        state.putMemoryRequestServer(server);
        return handle;
    }

    public static WritableHandle allocateDirect(long capacityBytes, MemoryRequestServer server) {
        if (capacityBytes == 0L) {
            return new WritableDirectHandle(null, BaseWritableMemoryImpl.ZERO_SIZE_MEMORY);
        }
        ResourceState state = new ResourceState(false);
        state.putCapacity(capacityBytes);
        state.putMemoryRequestServer(server);
        WritableDirectHandle handle = WritableDirectHandle.allocateDirect(state);
        return handle;
    }

    public abstract WritableMemory writableRegion(long var1, long var3);

    public abstract WritableBuffer asWritableBuffer();

    public static WritableMemory allocate(int capacityBytes) {
        byte[] arr = new byte[capacityBytes];
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.BYTE, arr.length), false);
    }

    public static WritableMemory wrap(boolean[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.BOOLEAN, arr.length), false);
    }

    public static WritableMemory wrap(byte[] arr) {
        return WritableMemory.wrap(arr, 0, arr.length, ByteOrder.nativeOrder());
    }

    public static WritableMemory wrap(byte[] arr, ByteOrder byteOrder) {
        return WritableMemory.wrap(arr, 0, arr.length, byteOrder);
    }

    public static WritableMemory wrap(byte[] arr, int offsetBytes, int lengthBytes, ByteOrder byteOrder) {
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, arr.length);
        ResourceState state = new ResourceState(arr, Prim.BYTE, lengthBytes);
        state.putRegionOffset(offsetBytes);
        state.putResourceOrder(byteOrder);
        return BaseWritableMemoryImpl.newInstance(state, false);
    }

    public static WritableMemory wrap(char[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.CHAR, arr.length), false);
    }

    public static WritableMemory wrap(short[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.SHORT, arr.length), false);
    }

    public static WritableMemory wrap(int[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.INT, arr.length), false);
    }

    public static WritableMemory wrap(long[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.LONG, arr.length), false);
    }

    public static WritableMemory wrap(float[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.FLOAT, arr.length), false);
    }

    public static WritableMemory wrap(double[] arr) {
        return BaseWritableMemoryImpl.newInstance(new ResourceState(arr, Prim.DOUBLE, arr.length), false);
    }

    public abstract void putBoolean(long var1, boolean var3);

    public abstract void putBooleanArray(long var1, boolean[] var3, int var4, int var5);

    public abstract void putByte(long var1, byte var3);

    public abstract void putByteArray(long var1, byte[] var3, int var4, int var5);

    public abstract void putChar(long var1, char var3);

    public abstract void putCharArray(long var1, char[] var3, int var4, int var5);

    public abstract long putCharsToUtf8(long var1, CharSequence var3);

    public abstract void putDouble(long var1, double var3);

    public abstract void putDoubleArray(long var1, double[] var3, int var4, int var5);

    public abstract void putFloat(long var1, float var3);

    public abstract void putFloatArray(long var1, float[] var3, int var4, int var5);

    public abstract void putInt(long var1, int var3);

    public abstract void putIntArray(long var1, int[] var3, int var4, int var5);

    public abstract void putLong(long var1, long var3);

    public abstract void putLongArray(long var1, long[] var3, int var4, int var5);

    public abstract void putShort(long var1, short var3);

    public abstract void putShortArray(long var1, short[] var3, int var4, int var5);

    public abstract long getAndAddLong(long var1, long var3);

    public abstract boolean compareAndSwapLong(long var1, long var3, long var5);

    public abstract long getAndSetLong(long var1, long var3);

    public abstract Object getArray();

    public abstract ByteBuffer getByteBuffer();

    public abstract void clear();

    public abstract void clear(long var1, long var3);

    public abstract void clearBits(long var1, byte var3);

    public abstract void fill(byte var1);

    public abstract void fill(long var1, long var3, byte var5);

    public abstract void setBits(long var1, byte var3);

    public abstract MemoryRequestServer getMemoryRequestServer();

    public abstract long getRegionOffset(long var1);
}

