/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableBufferImpl;
import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableBuffer;
import java.nio.ByteOrder;

final class NonNativeWritableBufferImpl
extends BaseWritableBufferImpl {
    NonNativeWritableBufferImpl(ResourceState state, boolean localReadOnly, BaseWritableMemoryImpl originMemory) {
        super(state, localReadOnly, originMemory);
        if (state.getResourceOrder() == ByteOrder.nativeOrder()) {
            throw new IllegalStateException("Expected non-native ordered state. This may be a bug in the Memory library.");
        }
    }

    @Override
    WritableBuffer writableDuplicateImpl(boolean localReadOnly) {
        this.checkValid();
        NonNativeWritableBufferImpl wBufImpl = new NonNativeWritableBufferImpl(this.state, localReadOnly, this.originMemory);
        wBufImpl.setStartPositionEnd(this.getStart(), this.getPosition(), this.getEnd());
        return wBufImpl;
    }

    @Override
    WritableBuffer writableRegionImpl(long offsetBytes, long capacityBytes, boolean localReadOnly) {
        this.checkValidAndBounds(offsetBytes, capacityBytes);
        ResourceState newState = this.state.copy();
        newState.putRegionOffset(newState.getRegionOffset() + offsetBytes);
        newState.putCapacity(capacityBytes);
        NonNativeWritableBufferImpl wBufImpl = new NonNativeWritableBufferImpl(newState, localReadOnly, this.originMemory);
        wBufImpl.setStartPositionEnd(0L, 0L, capacityBytes);
        return wBufImpl;
    }

    @Override
    public char getChar() {
        return Character.reverseBytes(this.getNativeOrderedChar());
    }

    @Override
    public char getChar(long offsetBytes) {
        return Character.reverseBytes(this.getNativeOrderedChar(offsetBytes));
    }

    @Override
    public void getCharArray(char[] dstArray, int dstOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeChars(this.unsafeObj, this.cumBaseOffset, pos, copyBytes, dstArray, dstOffsetChars, lengthChars);
    }

    @Override
    public double getDouble() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 8L);
        return Double.longBitsToDouble(Long.reverseBytes(UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + pos)));
    }

    @Override
    public double getDouble(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return Double.longBitsToDouble(Long.reverseBytes(UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + offsetBytes)));
    }

    @Override
    public void getDoubleArray(double[] dstArray, int dstOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeDoubles(this.unsafeObj, this.cumBaseOffset, pos, copyBytes, dstArray, dstOffsetDoubles, lengthDoubles);
    }

    @Override
    public float getFloat() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 4L);
        return Float.intBitsToFloat(Integer.reverseBytes(UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + pos)));
    }

    @Override
    public float getFloat(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return Float.intBitsToFloat(Integer.reverseBytes(UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + offsetBytes)));
    }

    @Override
    public void getFloatArray(float[] dstArray, int dstOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeFloats(this.unsafeObj, this.cumBaseOffset, pos, copyBytes, dstArray, dstOffsetFloats, lengthFloats);
    }

    @Override
    public int getInt() {
        return Integer.reverseBytes(this.getNativeOrderedInt());
    }

    @Override
    public int getInt(long offsetBytes) {
        return Integer.reverseBytes(this.getNativeOrderedInt(offsetBytes));
    }

    @Override
    public void getIntArray(int[] dstArray, int dstOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeInts(this.unsafeObj, this.cumBaseOffset, pos, copyBytes, dstArray, dstOffsetInts, lengthInts);
    }

    @Override
    public long getLong() {
        return Long.reverseBytes(this.getNativeOrderedLong());
    }

    @Override
    public long getLong(long offsetBytes) {
        return Long.reverseBytes(this.getNativeOrderedLong(offsetBytes));
    }

    @Override
    public void getLongArray(long[] dstArray, int dstOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeLongs(this.unsafeObj, this.cumBaseOffset, pos, copyBytes, dstArray, dstOffsetLongs, lengthLongs);
    }

    @Override
    public short getShort() {
        return Short.reverseBytes(this.getNativeOrderedShort());
    }

    @Override
    public short getShort(long offsetBytes) {
        return Short.reverseBytes(this.getNativeOrderedShort(offsetBytes));
    }

    @Override
    public void getShortArray(short[] dstArray, int dstOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        CompareAndCopy.getNonNativeShorts(this.unsafeObj, this.cumBaseOffset, pos, copyBytes, dstArray, dstOffsetShorts, lengthShorts);
    }

    @Override
    public void putChar(char value) {
        this.putNativeOrderedChar(Character.reverseBytes(value));
    }

    @Override
    public void putChar(long offsetBytes, char value) {
        this.putNativeOrderedChar(offsetBytes, Character.reverseBytes(value));
    }

    @Override
    public void putCharArray(char[] srcArray, int srcOffsetChars, int lengthChars) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthChars << 1;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeChars(srcArray, srcOffsetChars, lengthChars, copyBytes, this.unsafeObj, this.cumBaseOffset, pos);
    }

    @Override
    public void putDouble(double value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 8L);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + pos, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDouble(long offsetBytes, double value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, Long.reverseBytes(Double.doubleToRawLongBits(value)));
    }

    @Override
    public void putDoubleArray(double[] srcArray, int srcOffsetDoubles, int lengthDoubles) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthDoubles << 3;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeDoubles(srcArray, srcOffsetDoubles, lengthDoubles, copyBytes, this.unsafeObj, this.cumBaseOffset, pos);
    }

    @Override
    public void putFloat(float value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 4L);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + pos, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloat(long offsetBytes, float value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + offsetBytes, Integer.reverseBytes(Float.floatToRawIntBits(value)));
    }

    @Override
    public void putFloatArray(float[] srcArray, int srcOffsetFloats, int lengthFloats) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthFloats << 2;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeFloats(srcArray, srcOffsetFloats, lengthFloats, copyBytes, this.unsafeObj, this.cumBaseOffset, pos);
    }

    @Override
    public void putInt(int value) {
        this.putNativeOrderedInt(Integer.reverseBytes(value));
    }

    @Override
    public void putInt(long offsetBytes, int value) {
        this.putNativeOrderedInt(offsetBytes, Integer.reverseBytes(value));
    }

    @Override
    public void putIntArray(int[] srcArray, int srcOffsetInts, int lengthInts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthInts << 2;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeInts(srcArray, srcOffsetInts, lengthInts, copyBytes, this.unsafeObj, this.cumBaseOffset, pos);
    }

    @Override
    public void putLong(long value) {
        this.putNativeOrderedLong(Long.reverseBytes(value));
    }

    @Override
    public void putLong(long offsetBytes, long value) {
        this.putNativeOrderedLong(offsetBytes, Long.reverseBytes(value));
    }

    @Override
    public void putLongArray(long[] srcArray, int srcOffsetLongs, int lengthLongs) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthLongs << 3;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeLongs(srcArray, srcOffsetLongs, lengthLongs, copyBytes, this.unsafeObj, this.cumBaseOffset, pos);
    }

    @Override
    public void putShort(short value) {
        this.putNativeOrderedShort(Short.reverseBytes(value));
    }

    @Override
    public void putShort(long offsetBytes, short value) {
        this.putNativeOrderedShort(offsetBytes, Short.reverseBytes(value));
    }

    @Override
    public void putShortArray(short[] srcArray, int srcOffsetShorts, int lengthShorts) {
        long pos = this.getPosition();
        long copyBytes = (long)lengthShorts << 1;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        CompareAndCopy.putNonNativeShorts(srcArray, srcOffsetShorts, lengthShorts, copyBytes, this.unsafeObj, this.cumBaseOffset, pos);
    }
}

