/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.BaseWritableMemoryImpl;
import com.yahoo.memory.Buffer;
import com.yahoo.memory.CompareAndCopy;
import com.yahoo.memory.Memory;
import com.yahoo.memory.Prim;
import com.yahoo.memory.ReadOnlyException;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import com.yahoo.memory.WritableBuffer;
import com.yahoo.memory.WritableBufferImpl;
import com.yahoo.memory.WritableMemory;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class BaseWritableBufferImpl
extends WritableBuffer {
    final ResourceState state;
    final Object unsafeObj;
    final long cumBaseOffset;
    final boolean localReadOnly;
    final BaseWritableMemoryImpl originMemory;
    static final WritableBufferImpl ZERO_SIZE_BUFFER;

    BaseWritableBufferImpl(ResourceState state, boolean localReadOnly, BaseWritableMemoryImpl originMemory) {
        super(state.getCapacity());
        this.state = state;
        this.unsafeObj = state.getUnsafeObject();
        this.cumBaseOffset = state.getCumBaseOffset();
        this.localReadOnly = localReadOnly;
        this.originMemory = originMemory;
    }

    @Override
    public Buffer duplicate() {
        return this.writableDuplicateImpl(false);
    }

    @Override
    public WritableBuffer writableDuplicate() {
        return this.writableDuplicateImpl(this.localReadOnly);
    }

    abstract WritableBuffer writableDuplicateImpl(boolean var1);

    @Override
    public Buffer region() {
        return this.writableRegionImpl(this.getPosition(), this.getEnd() - this.getPosition(), true);
    }

    @Override
    public WritableBuffer writableRegion() {
        return this.writableRegionImpl(this.getPosition(), this.getEnd() - this.getPosition(), this.localReadOnly);
    }

    @Override
    public WritableBuffer writableRegion(long offsetBytes, long capacityBytes) {
        return this.writableRegionImpl(offsetBytes, capacityBytes, this.localReadOnly);
    }

    abstract WritableBuffer writableRegionImpl(long var1, long var3, boolean var5);

    @Override
    public Memory asMemory() {
        return this.originMemory;
    }

    @Override
    public WritableMemory asWritableMemory() {
        if (this.localReadOnly) {
            throw new ReadOnlyException("This Buffer is Read-Only.");
        }
        return this.originMemory;
    }

    @Override
    public final boolean getBoolean() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 1L);
        return UnsafeUtil.unsafe.getBoolean(this.unsafeObj, this.cumBaseOffset + pos);
    }

    @Override
    public final boolean getBoolean(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getBoolean(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public final void getBooleanArray(boolean[] dstArray, int dstOffsetBooleans, int lengthBooleans) {
        long pos = this.getPosition();
        long copyBytes = lengthBooleans;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBooleans, lengthBooleans, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)dstOffsetBooleans, copyBytes);
    }

    @Override
    public final byte getByte() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 1L);
        return UnsafeUtil.unsafe.getByte(this.unsafeObj, this.cumBaseOffset + pos);
    }

    @Override
    public final byte getByte(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 1L);
        return UnsafeUtil.unsafe.getByte(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public final void getByteArray(byte[] dstArray, int dstOffsetBytes, int lengthBytes) {
        long pos = this.getPosition();
        long copyBytes = lengthBytes;
        this.incrementAndCheckPositionForRead(pos, copyBytes);
        UnsafeUtil.checkBounds(dstOffsetBytes, lengthBytes, dstArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(this.unsafeObj, this.cumBaseOffset + pos, dstArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)dstOffsetBytes, copyBytes);
    }

    final char getNativeOrderedChar() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 2L);
        return UnsafeUtil.unsafe.getChar(this.unsafeObj, this.cumBaseOffset + pos);
    }

    final char getNativeOrderedChar(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getChar(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    final int getNativeOrderedInt() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 4L);
        return UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + pos);
    }

    final int getNativeOrderedInt(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 4L);
        return UnsafeUtil.unsafe.getInt(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    final long getNativeOrderedLong() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 8L);
        return UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + pos);
    }

    final long getNativeOrderedLong(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 8L);
        return UnsafeUtil.unsafe.getLong(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    final short getNativeOrderedShort() {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForRead(pos, 2L);
        return UnsafeUtil.unsafe.getShort(this.unsafeObj, this.cumBaseOffset + pos);
    }

    final short getNativeOrderedShort(long offsetBytes) {
        this.assertValidAndBoundsForRead(offsetBytes, 2L);
        return UnsafeUtil.unsafe.getShort(this.unsafeObj, this.cumBaseOffset + offsetBytes);
    }

    @Override
    public final int compareTo(long thisOffsetBytes, long thisLengthBytes, Buffer thatBuf, long thatOffsetBytes, long thatLengthBytes) {
        return CompareAndCopy.compare(this.state, thisOffsetBytes, thisLengthBytes, thatBuf.getResourceState(), thatOffsetBytes, thatLengthBytes);
    }

    @Override
    public final void checkValidAndBounds(long offsetBytes, long lengthBytes) {
        this.checkValid();
        UnsafeUtil.checkBounds(offsetBytes, lengthBytes, this.capacity);
    }

    @Override
    public final long getCapacity() {
        this.assertValid();
        return this.capacity;
    }

    @Override
    public final long getCumulativeOffset() {
        this.assertValid();
        return this.cumBaseOffset;
    }

    @Override
    public final long getRegionOffset() {
        this.assertValid();
        return this.state.getRegionOffset();
    }

    @Override
    public final boolean hasArray() {
        this.assertValid();
        return this.unsafeObj != null;
    }

    @Override
    public final boolean hasByteBuffer() {
        this.assertValid();
        return this.state.getByteBuffer() != null;
    }

    @Override
    public final boolean isDirect() {
        this.assertValid();
        return this.state.isDirect();
    }

    @Override
    public final boolean isReadOnly() {
        this.assertValid();
        return this.state.isResourceReadOnly() || this.localReadOnly;
    }

    @Override
    public final boolean isSameResource(Buffer that) {
        if (that == null) {
            return false;
        }
        this.checkValid();
        that.checkValid();
        return this.state.isSameResource(that.getResourceState());
    }

    @Override
    public final boolean isValid() {
        return this.state.isValid();
    }

    @Override
    public final ByteOrder getResourceOrder() {
        this.assertValid();
        return this.state.getResourceOrder();
    }

    @Override
    public final boolean isSwapBytes() {
        return this.state.isSwapBytes();
    }

    @Override
    public final String toHexString(String header, long offsetBytes, int lengthBytes) {
        this.checkValid();
        String klass = this.getClass().getSimpleName();
        String s1 = String.format("(..., %d, %d)", offsetBytes, lengthBytes);
        long hcode = (long)this.hashCode() & 0xFFFFFFFFL;
        String call = ".toHexString" + s1 + ", hashCode: " + hcode;
        StringBuilder sb = new StringBuilder();
        sb.append("### ").append(klass).append(" SUMMARY ###").append(UnsafeUtil.LS);
        sb.append("Header Comment      : ").append(header).append(UnsafeUtil.LS);
        sb.append("Call Parameters     : ").append(call);
        return Memory.toHex(sb.toString(), offsetBytes, lengthBytes, this.state, this.localReadOnly);
    }

    @Override
    public final void putBoolean(boolean value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 1L);
        UnsafeUtil.unsafe.putBoolean(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    @Override
    public final void putBoolean(long offsetBytes, boolean value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putBoolean(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public final void putBooleanArray(boolean[] srcArray, int srcOffsetBooleans, int lengthBooleans) {
        long pos = this.getPosition();
        long copyBytes = lengthBooleans;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBooleans, lengthBooleans, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BOOLEAN_BASE_OFFSET + (long)srcOffsetBooleans, this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    @Override
    public final void putByte(byte value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 1L);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    @Override
    public final void putByte(long offsetBytes, byte value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 1L);
        UnsafeUtil.unsafe.putByte(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public final void putByteArray(byte[] srcArray, int srcOffsetBytes, int lengthBytes) {
        long pos = this.getPosition();
        long copyBytes = lengthBytes;
        this.incrementAndCheckPositionForWrite(pos, copyBytes);
        UnsafeUtil.checkBounds(srcOffsetBytes, lengthBytes, srcArray.length);
        CompareAndCopy.copyMemoryCheckingDifferentObject(srcArray, UnsafeUtil.ARRAY_BYTE_BASE_OFFSET + (long)srcOffsetBytes, this.unsafeObj, this.cumBaseOffset + pos, copyBytes);
    }

    final void putNativeOrderedChar(char value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 2L);
        UnsafeUtil.unsafe.putChar(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    final void putNativeOrderedChar(long offsetBytes, char value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putChar(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    final void putNativeOrderedInt(int value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 4L);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    final void putNativeOrderedInt(long offsetBytes, int value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 4L);
        UnsafeUtil.unsafe.putInt(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    final void putNativeOrderedLong(long value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 8L);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    final void putNativeOrderedLong(long offsetBytes, long value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 8L);
        UnsafeUtil.unsafe.putLong(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    final void putNativeOrderedShort(short value) {
        long pos = this.getPosition();
        this.incrementAndAssertPositionForWrite(pos, 2L);
        UnsafeUtil.unsafe.putShort(this.unsafeObj, this.cumBaseOffset + pos, value);
    }

    final void putNativeOrderedShort(long offsetBytes, short value) {
        this.assertValidAndBoundsForWrite(offsetBytes, 2L);
        UnsafeUtil.unsafe.putShort(this.unsafeObj, this.cumBaseOffset + offsetBytes, value);
    }

    @Override
    public final Object getArray() {
        this.assertValid();
        return this.unsafeObj;
    }

    @Override
    public final ByteBuffer getByteBuffer() {
        this.assertValid();
        return this.state.getByteBuffer();
    }

    @Override
    public final void clear() {
        this.fill((byte)0);
    }

    @Override
    public final void fill(byte value) {
        long chunk;
        long len;
        this.checkValidForWrite();
        long pos = this.getPosition();
        BaseWritableBufferImpl.checkInvariants(this.getStart(), pos + len, this.getEnd(), this.getCapacity());
        for (len = this.getEnd() - pos; len > 0L; len -= chunk) {
            chunk = Math.min(len, 0x100000L);
            UnsafeUtil.unsafe.setMemory(this.unsafeObj, this.cumBaseOffset + pos, chunk, value);
            pos += chunk;
        }
    }

    @Override
    final ResourceState getResourceState() {
        this.assertValid();
        return this.state;
    }

    @Override
    final void assertValid() {
        assert (this.state.isValid()) : "Buffer not valid.";
    }

    @Override
    final void checkValid() {
        this.state.checkValid();
    }

    final void assertValidAndBoundsForRead(long offsetBytes, long lengthBytes) {
        this.assertValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacity);
    }

    final void assertValidAndBoundsForWrite(long offsetBytes, long lengthBytes) {
        this.assertValid();
        UnsafeUtil.assertBounds(offsetBytes, lengthBytes, this.capacity);
        assert (!this.localReadOnly) : "Buffer is read-only.";
    }

    static {
        ResourceState state = new ResourceState(new byte[0], Prim.BYTE, 0L);
        ZERO_SIZE_BUFFER = new WritableBufferImpl(state, true, BaseWritableMemoryImpl.ZERO_SIZE_MEMORY);
    }
}

