/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.NioBits;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.StepBoolean;
import com.yahoo.memory.UnsafeUtil;
import sun.misc.Cleaner;

final class AllocateDirect
implements AutoCloseable {
    private final StepBoolean valid;
    private final long capacity;
    private final Cleaner cleaner;

    private AllocateDirect(long capacity, ResourceState state) {
        long nativeAddress;
        this.valid = state.getValid();
        this.capacity = capacity;
        boolean pageAligned = NioBits.isPageAligned();
        long pageSize = NioBits.pageSize();
        long allocationSize = capacity + (pageAligned ? pageSize : 0L);
        NioBits.reserveMemory(capacity);
        try {
            nativeAddress = UnsafeUtil.unsafe.allocateMemory(allocationSize);
        }
        catch (OutOfMemoryError err) {
            NioBits.unreserveMemory(capacity);
            throw err;
        }
        long nativeBaseOffset = pageAligned && nativeAddress % pageSize != 0L ? (nativeAddress & (pageSize - 1L ^ 0xFFFFFFFFFFFFFFFFL)) + pageSize : nativeAddress;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Deallocator(nativeAddress, capacity, this.valid));
        state.putNativeBaseOffset(nativeBaseOffset);
        ResourceState.currentDirectMemoryAllocations_.incrementAndGet();
        ResourceState.currentDirectMemoryAllocated_.addAndGet(state.getCapacity());
    }

    static AllocateDirect allocateDirect(long capacity, ResourceState state) {
        return new AllocateDirect(capacity, state);
    }

    @Override
    public void close() {
        if (this.valid.get()) {
            ResourceState.currentDirectMemoryAllocations_.decrementAndGet();
            ResourceState.currentDirectMemoryAllocated_.addAndGet(-this.capacity);
        }
        this.cleaner.clean();
    }

    private static final class Deallocator
    implements Runnable {
        private long nativeAddress;
        private final long capacity;
        private StepBoolean valid;

        private Deallocator(long nativeAddress, long capacity, StepBoolean valid) {
            this.nativeAddress = nativeAddress;
            this.capacity = capacity;
            this.valid = valid;
            assert (nativeAddress != 0L);
        }

        @Override
        public void run() {
            this.valid.change();
            if (this.nativeAddress > 0L) {
                UnsafeUtil.unsafe.freeMemory(this.nativeAddress);
                NioBits.unreserveMemory(this.capacity);
            }
            this.nativeAddress = 0L;
        }
    }
}

