/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.Map;
import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import sun.misc.Cleaner;
import sun.nio.ch.FileChannelImpl;

class AllocateDirectMap
implements Map {
    final ResourceState state;
    final Cleaner cleaner;

    AllocateDirectMap(ResourceState state) {
        this.state = state;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Deallocator(state));
        ResourceState.currentDirectMemoryMapAllocations_.incrementAndGet();
        ResourceState.currentDirectMemoryMapAllocated_.addAndGet(state.getCapacity());
    }

    static AllocateDirectMap map(ResourceState state) throws Exception {
        return new AllocateDirectMap(AllocateDirectMap.mapper(state));
    }

    @Override
    public void load() {
        this.madvise();
        int ps = UnsafeUtil.unsafe.pageSize();
        int count = AllocateDirectMap.pageCount(ps, this.state.getCapacity());
        long nativeBaseOffset = this.state.getNativeBaseOffset();
        for (int i = 0; i < count; ++i) {
            UnsafeUtil.unsafe.getByte(nativeBaseOffset);
            nativeBaseOffset += (long)ps;
        }
    }

    @Override
    public boolean isLoaded() {
        int ps = UnsafeUtil.unsafe.pageSize();
        long nativeBaseOffset = this.state.getNativeBaseOffset();
        try {
            int pageCount = AllocateDirectMap.pageCount(ps, this.state.getCapacity());
            Method method = MappedByteBuffer.class.getDeclaredMethod("isLoaded0", Long.TYPE, Long.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)this.state.getMappedByteBuffer(), nativeBaseOffset, this.state.getCapacity(), pageCount);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    @Override
    public void close() {
        if (this.state.isValid()) {
            ResourceState.currentDirectMemoryMapAllocations_.decrementAndGet();
            ResourceState.currentDirectMemoryMapAllocated_.addAndGet(-this.state.getCapacity());
        }
        this.cleaner.clean();
    }

    static final ResourceState mapper(ResourceState state) throws Exception {
        long fileOffset = state.getFileOffset();
        long capacity = state.getCapacity();
        AllocateDirectMap.checkOffsetAndCapacity(fileOffset, capacity);
        File file = state.getFile();
        if (AllocateDirectMap.isFileReadOnly(file)) {
            state.setResourceReadOnly();
        }
        String mode = "rw";
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        state.putRandomAccessFile(raf);
        FileChannel fc = raf.getChannel();
        long nativeBaseOffset = AllocateDirectMap.map(fc, fileOffset, capacity);
        state.putNativeBaseOffset(nativeBaseOffset);
        raf.setLength(capacity);
        MappedByteBuffer mbb = AllocateDirectMap.createDummyMbbInstance(nativeBaseOffset);
        state.putMappedByteBuffer(mbb);
        return state;
    }

    static final int pageCount(int ps, long capacity) {
        return (int)(capacity == 0L ? 0L : (capacity - 1L) / (long)ps + 1L);
    }

    static final MappedByteBuffer createDummyMbbInstance(long nativeBaseAddress) throws RuntimeException {
        try {
            Class<?> cl = Class.forName("java.nio.DirectByteBuffer");
            Constructor<?> ctor = cl.getDeclaredConstructor(Integer.TYPE, Long.TYPE, FileDescriptor.class, Runnable.class);
            ctor.setAccessible(true);
            MappedByteBuffer mbb = (MappedByteBuffer)ctor.newInstance(0, nativeBaseAddress, null, null);
            return mbb;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create Dummy MappedByteBuffer instance: " + e.getClass());
        }
    }

    void madvise() throws RuntimeException {
        try {
            Method method = MappedByteBuffer.class.getDeclaredMethod("load0", Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.state.getMappedByteBuffer(), this.state.getNativeBaseOffset(), this.state.getCapacity());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while loading", e.getClass()));
        }
    }

    static final long map(FileChannel fileChannel, long position, long lengthBytes) throws RuntimeException {
        int pagePosition = (int)(position % (long)UnsafeUtil.unsafe.pageSize());
        long mapPosition = position - (long)pagePosition;
        long mapSize = lengthBytes + (long)pagePosition;
        try {
            Method method = FileChannelImpl.class.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
            method.setAccessible(true);
            long nativeBaseOffset = (Long)method.invoke((Object)fileChannel, 1, mapPosition, mapSize);
            return nativeBaseOffset;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Encountered %s exception while mapping", e.getClass()));
        }
    }

    static final void checkOffsetAndCapacity(long offset, long capacity) {
        if ((offset | capacity - 1L | offset + capacity) < 0L) {
            throw new IllegalArgumentException("offset: " + offset + ", capacity: " + capacity + ", offset + capacity: " + (offset + capacity));
        }
    }

    static final boolean isFileReadOnly(File file) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return !file.canWrite();
        }
        Path path = Paths.get(file.getAbsolutePath(), new String[0]);
        PosixFileAttributes attributes = null;
        try {
            attributes = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (attributes == null) {
            return false;
        }
        Set<PosixFilePermission> permissions = attributes.permissions();
        int bits = 0;
        bits |= permissions.contains((Object)PosixFilePermission.OWNER_READ) ? 256 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OWNER_WRITE) ? 128 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE) ? 64 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.GROUP_READ) ? 32 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.GROUP_WRITE) ? 16 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE) ? 8 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OTHERS_READ) ? 4 : 0;
        bits |= permissions.contains((Object)PosixFilePermission.OTHERS_WRITE) ? 2 : 0;
        return ((bits |= permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE) ? 1 : 0) & 0x13F) == 292;
    }

    private static final class Deallocator
    implements Runnable {
        private final RandomAccessFile myRaf;
        private final FileChannel myFc;
        private long actualNativeBaseOffset;
        private final long myCapacity;
        private final ResourceState parentStateRef;

        private Deallocator(ResourceState state) {
            this.myRaf = state.getRandomAccessFile();
            assert (this.myRaf != null);
            this.myFc = this.myRaf.getChannel();
            this.actualNativeBaseOffset = state.getNativeBaseOffset();
            assert (this.actualNativeBaseOffset != 0L);
            this.myCapacity = state.getCapacity();
            assert (this.myCapacity != 0L);
            this.parentStateRef = state;
        }

        @Override
        public void run() {
            if (this.myFc != null) {
                this.unmap();
            }
            this.actualNativeBaseOffset = 0L;
            this.parentStateRef.setInvalid();
        }

        private void unmap() throws RuntimeException {
            try {
                Method method = FileChannelImpl.class.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
                method.setAccessible(true);
                method.invoke((Object)this.myFc, this.actualNativeBaseOffset, this.myCapacity);
                this.myRaf.close();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Encountered %s exception while freeing memory", e.getClass()));
            }
        }
    }
}

