/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.memory;

import com.yahoo.memory.ResourceState;
import com.yahoo.memory.UnsafeUtil;
import sun.misc.Cleaner;

final class AllocateDirect
implements AutoCloseable {
    final ResourceState state;
    private final Cleaner cleaner;

    private AllocateDirect(ResourceState state) {
        this.state = state;
        this.cleaner = Cleaner.create((Object)this, (Runnable)new Deallocator(state));
        ResourceState.currentDirectMemoryAllocations_.incrementAndGet();
        ResourceState.currentDirectMemoryAllocated_.addAndGet(state.getCapacity());
    }

    static AllocateDirect allocate(ResourceState state) {
        state.putNativeBaseOffset(UnsafeUtil.unsafe.allocateMemory(state.getCapacity()));
        return new AllocateDirect(state);
    }

    @Override
    public void close() {
        if (this.state.isValid()) {
            ResourceState.currentDirectMemoryAllocations_.decrementAndGet();
            ResourceState.currentDirectMemoryAllocated_.addAndGet(-this.state.getCapacity());
        }
        this.cleaner.clean();
    }

    private static final class Deallocator
    implements Runnable {
        private long actualNativeBaseOffset;
        private final ResourceState parentStateRef;

        private Deallocator(ResourceState state) {
            this.actualNativeBaseOffset = state.getNativeBaseOffset();
            assert (this.actualNativeBaseOffset != 0L);
            this.parentStateRef = state;
        }

        @Override
        public void run() {
            if (this.actualNativeBaseOffset == 0L) {
                return;
            }
            UnsafeUtil.unsafe.freeMemory(this.actualNativeBaseOffset);
            this.actualNativeBaseOffset = 0L;
            this.parentStateRef.setInvalid();
        }
    }
}

