/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.decoration;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;

public class GridItemDecoration
extends RecyclerView.ItemDecoration {
    private int mNumColumns;
    private int mSizeGridSpacingPx = 10;
    private boolean mNeedLeftSpacing = false;

    public GridItemDecoration(int spacingPx, int numColumns) {
        this.mSizeGridSpacingPx = spacingPx;
        this.mNumColumns = numColumns;
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int frameWidth = (int)(((float)parent.getWidth() - (float)this.mSizeGridSpacingPx * (float)(this.mNumColumns - 1)) / (float)this.mNumColumns);
        int padding = parent.getWidth() / this.mNumColumns - frameWidth;
        int itemPosition = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewAdapterPosition();
        outRect.top = itemPosition < this.mNumColumns ? 0 : this.mSizeGridSpacingPx;
        if (itemPosition % this.mNumColumns == 0) {
            outRect.left = 0;
            outRect.right = padding;
            this.mNeedLeftSpacing = true;
        } else if ((itemPosition + 1) % this.mNumColumns == 0) {
            this.mNeedLeftSpacing = false;
            outRect.right = 0;
            outRect.left = padding;
        } else if (this.mNeedLeftSpacing) {
            this.mNeedLeftSpacing = false;
            outRect.left = this.mSizeGridSpacingPx - padding;
            outRect.right = (itemPosition + 2) % this.mNumColumns == 0 ? this.mSizeGridSpacingPx - padding : this.mSizeGridSpacingPx / 2;
        } else if ((itemPosition + 2) % this.mNumColumns == 0) {
            this.mNeedLeftSpacing = false;
            outRect.left = this.mSizeGridSpacingPx / 2;
            outRect.right = this.mSizeGridSpacingPx - padding;
        } else {
            this.mNeedLeftSpacing = false;
            outRect.left = this.mSizeGridSpacingPx / 2;
            outRect.right = this.mSizeGridSpacingPx / 2;
        }
        outRect.bottom = 0;
    }
}

