/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseListAdapter<T>
extends BaseAdapter {
    private static final String TAG = BaseListAdapter.class.getSimpleName();
    protected LayoutInflater inflater;
    protected Context context;
    protected List<T> objectsList;
    protected int displayItemCount;
    private PaginationListener paginationListener;
    private boolean isPageLoading;

    public BaseListAdapter(Context context) {
        this(context, new ArrayList());
    }

    public BaseListAdapter(Context context, List<T> objectsList) {
        this.context = context;
        this.objectsList = objectsList;
        this.inflater = LayoutInflater.from((Context)context);
        this.displayItemCount = objectsList.size();
    }

    public void setPageLoading(boolean pageLoading) {
        this.isPageLoading = pageLoading;
    }

    public boolean isPageLoading() {
        return this.isPageLoading;
    }

    public void setDisplayItemCount(int itemCount) {
        this.displayItemCount = itemCount;
    }

    public void setPaginationListener(PaginationListener paginationListener) {
        this.paginationListener = paginationListener;
    }

    public int getItemViewType(int position) {
        return super.getItemViewType(position);
    }

    public int getCount() {
        if (this.objectsList.size() < this.displayItemCount) {
            this.displayItemCount = this.objectsList.size();
        }
        return this.displayItemCount;
    }

    public T getItem(int position) {
        return this.objectsList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void updateList(List<T> newData) {
        this.objectsList = newData;
        this.displayItemCount = this.objectsList.size();
        this.notifyDataSetChanged();
    }

    public void add(T item) {
        this.objectsList.add(item);
        this.displayItemCount = this.objectsList.size();
        this.notifyDataSetChanged();
    }

    public void addAt(int position, T item) {
        this.objectsList.add(position, item);
        this.displayItemCount = this.objectsList.size();
        this.notifyDataSetChanged();
    }

    public void addList(List<T> items) {
        this.objectsList.addAll(0, items);
        this.displayItemCount = this.objectsList.size();
        this.notifyDataSetChanged();
    }

    public void addAtLast(List<T> items) {
        if (this.isPageLoading()) {
            this.objectsList.addAll(this.objectsList.size() - 1, items);
        } else {
            this.objectsList.addAll(items);
        }
        this.displayItemCount = this.objectsList.size();
        this.notifyDataSetChanged();
    }

    public List<T> getList() {
        return this.objectsList;
    }

    public void remove(T item) {
        this.objectsList.remove(item);
        this.displayItemCount = this.objectsList.size();
        this.notifyDataSetChanged();
    }

    public void remove(int position) {
        this.objectsList.remove(position);
        this.displayItemCount = this.objectsList.size();
    }

    protected void loadNextPage(int position) {
        if (this.paginationListener != null && position == this.objectsList.size() - 1) {
            if (this.isPageLoading()) {
                this.paginationListener.onPageLoad(this.objectsList.size() - 1);
            } else {
                this.paginationListener.onPageLoad(this.objectsList.size());
            }
        }
    }

    public static interface PaginationListener {
        public void onPageLoad(int var1);
    }
}

