/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.util.Base64;

import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.RoundedBitmapDrawable;
import androidx.core.graphics.drawable.RoundedBitmapDrawableFactory;

import com.xtensolution.support.exceptions.FileExtensionNotFoundException;

import java.io.ByteArrayOutputStream;

public class ImageUtils {
    private static final String TAG = ImageUtils.class.getSimpleName();

    private ImageUtils() {
    }

    // convert from bitmap to byte array
    public static byte[] getBytes(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, stream);
        return stream.toByteArray();
    }

    // convert from byte array to bitmap
    public static Bitmap getImage(byte[] image) {
        return BitmapFactory.decodeByteArray(image, 0, image.length);
    }

    public static Drawable getRoundedDrawable(Context context, int width, int height, Bitmap bmp) {
        Bitmap bitmap = Bitmap.createScaledBitmap(bmp, width, height, false);
        RoundedBitmapDrawable drawable = RoundedBitmapDrawableFactory.create(context.getResources(), bitmap);
        drawable.setCircular(true);
        return drawable;
    }

    public static Drawable getFileIcon(Context context, String extension) {
        int resId = FileExtensionUtils.getResourceId(extension);
        if (resId != 0) {
            return ContextCompat.getDrawable(context, resId);
        } else {
            throw new FileExtensionNotFoundException("File extension " + extension + " not found");
        }
    }

    public static String convertToBase64(Bitmap bitmap) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, baos);
            byte[] b = baos.toByteArray();
            return Base64.encodeToString(b, Base64.DEFAULT);
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
            return "";
        }
    }

    public static Bitmap convertBase64ToBitmap(String base64) {
        try {
            byte[] bytarray = Base64.decode(base64, Base64.DEFAULT);
            return BitmapFactory.decodeByteArray(bytarray, 0,
                    bytarray.length);
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
            return null;
        }
    }
}
