/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.ui.adapter;

import android.content.Context;
import android.view.ViewGroup;

import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

/**
 * Created by niravvalera on 04/12/17.
 */

public abstract class StickyHeaderRecyclerAdapter<T> extends BaseSelectedRecyclerViewAdapter<T> {
    private long prevHeaderId;


    public StickyHeaderRecyclerAdapter(Context context, List<T> objectsList) {
        super(context, objectsList);
    }

    public abstract long getHeaderId(int position);

    public abstract RecyclerView.ViewHolder onCreateHeaderViewHolder(ViewGroup parent, int viewType);

//    public abstract void onBindHeaderViewHolder(RecyclerView.ViewHolder holder, int position);
}
