package com.xtensolution.support.ui.activity;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;

import com.xtensolution.support.R;
import com.xtensolution.support.exceptions.FragmentContainerResourceNotFoundException;
import com.xtensolution.support.ui.fragment.CoreBaseFragment;
import com.xtensolution.support.ui.listener.MenuCheckedListener;
import com.xtensolution.support.utils.AppLog;
import com.xtensolution.support.utils.ResourceUtils;

/**
 * Created by Vaghela Mithun R. on 2019-09-16.
 * Smart Call Center Solution Pvt. Ltd.
 * mithun@smartadvancedtech.com
 */
public abstract class CoreFragmentActivity extends CoreActionBarActivity implements MenuCheckedListener {
    private static final String TAG = CoreFragmentActivity.class.getSimpleName();
    protected Fragment currentLoadedFragment;

    public void replaceFragment(Fragment fragment) {
        try {

            if (fragment instanceof CoreBaseFragment) {
                CoreBaseFragment baseFragment = (CoreBaseFragment) fragment;
                if (baseFragment.isHomePage()) {
                    onBackPressed();
                    return;
                }
            }

            if (getFragmentContainer() != 0) {
                currentLoadedFragment = getSupportFragmentManager().findFragmentById(getFragmentContainer());

                if (currentLoadedFragment != null && currentLoadedFragment.getTag() != null) {
                    String tag = fragment.getClass().getSimpleName();
                    if (currentLoadedFragment.getTag().equalsIgnoreCase(tag)) {
                        return;
                    }
                }

                super.replaceFragment(fragment);
            } else {
                throw new FragmentContainerResourceNotFoundException(ResourceUtils.getString(R.string.no_fragment_container_found));
            }
        } catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    @Override
    public int getPageMenuId() {
        return 0;
    }

    @Override
    public boolean isHomePage() {
        return false;
    }

    public void resetTitle() {
        if (getFragmentContainer() != 0) {
            Fragment fragment = getSupportFragmentManager().findFragmentById(getFragmentContainer());
            if (fragment instanceof CoreBaseFragment) {
                CoreBaseFragment baseFragment = (CoreBaseFragment) fragment;
                setActionBarTitle(baseFragment.getScreenTitle());
            }
        }
    }
}
