/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.ui.activity;


import android.view.MenuItem;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;

/**
 * A abstract {@link CoreBaseActivity} subclass.
 * Activities that contain actionbar must extends this class
 */

public abstract class CoreActionBarActivity extends CoreBaseActivity {
    protected Toolbar mToolbar;
    protected ActionBar mActionBar;

    @Override
    protected void onContentViewBind() {
        mToolbar = _findViewById(getToolbarId());
        setSupportActionBar(mToolbar);
        mActionBar = getSupportActionBar();
        onActionBarAttached();
    }

    /**
     * Use this factory method to get the toolbar resource id
     * to init the toolbar from extend child class.
     * @return toolbar resource id.
     */
    protected abstract int getToolbarId();

    /**
     * Use this factory method to listen the actionbar has been
     * attached to activity
     * @return void
     */
    protected abstract void onActionBarAttached();

    @Override
    protected void onResume() {
        super.onResume();
        setActionBarTitle(getScreenTitle());
    }

    /**
     * To handle the action bar title
     * @param title
     */
    public void setActionBarTitle(int title) {
        if (mActionBar != null) {
            mActionBar.setTitle(title);
        }
    }

    /**
     * To handle the action bar title
     * @param title
     */
    public void setActionBarTitle(CharSequence title) {
        if (mActionBar != null) {
            mActionBar.setTitle(title);
        }
    }

    /**
     * To handle the action bar subtitle
     * @param subtitle
     */
    public void setActionBarSubtitle(int subtitle) {
        if (mActionBar != null) {
            mActionBar.setTitle(subtitle);
        }
    }

    /**
     * To handle the action bar subtitle
     * @param subtitle
     */
    public void setActionBarSubtitle(CharSequence subtitle) {
        if (mActionBar != null) {
            mActionBar.setTitle(subtitle);
        }
    }

    /**
     * To handle the home button action enable or disable
     * @param enable
     */
    protected void setHomeButtonEnable(boolean enable) {
        if (mActionBar != null) {
            mActionBar.setHomeButtonEnabled(enable);
            mActionBar.setDisplayHomeAsUpEnabled(enable);
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home)
            onBackPressed();

        return super.onOptionsItemSelected(item);
    }

    /**
     * A abstract method to get the current screen title
     * from child class
     * @return string
     */
    protected abstract String getScreenTitle();
}
