/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;

public class CompatibilityUtil {
    public static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isFroyo() {
        return CompatibilityUtil.getSdkVersion() >= 8;
    }

    public static boolean isHoneycomb() {
        return CompatibilityUtil.getSdkVersion() >= 11;
    }

    public static boolean isLollipop() {
        return CompatibilityUtil.getSdkVersion() >= 21;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    @TargetApi(value=13)
    public static boolean isTelevision(Context context) {
        return context.getPackageManager().hasSystemFeature("com.google.android.tv");
    }

    public static boolean isHoneycombTablet(Context context) {
        return CompatibilityUtil.isHoneycomb() && CompatibilityUtil.isTablet(context);
    }

    private CompatibilityUtil() {
    }

    public static boolean isGingerbread() {
        return Build.VERSION.SDK_INT >= 9;
    }

    public static boolean isICS() {
        return Build.VERSION.SDK_INT >= 14;
    }

    public static boolean isJellyBean() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isMarshmallow() {
        return CompatibilityUtil.getSdkVersion() >= 23;
    }

    public static boolean isNaught() {
        return CompatibilityUtil.getSdkVersion() >= 24;
    }

    public static boolean isNaughtMR1() {
        return CompatibilityUtil.getSdkVersion() >= 25;
    }
}

