/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.fragment;

import android.content.Context;
import android.view.View;
import android.widget.ProgressBar;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.xtensolution.support.exceptions.RecyclerViewNotFoundException;
import com.xtensolution.support.ui.fragment.CoreBaseFragment;
import com.xtensolution.support.ui.listener.RecyclerBinderListener;
import com.xtensolution.support.utils.AppLog;

public abstract class CoreRecyclerViewBaseFragment
extends CoreBaseFragment
implements RecyclerBinderListener {
    private static final String TAG = CoreRecyclerViewBaseFragment.class.getSimpleName();
    protected RecyclerView recyclerView;
    protected int orientation = 1;
    protected RecyclerView.LayoutManager manager;
    protected ProgressBar progressBar;
    protected SwipeRefreshLayout refreshLayout;
    protected FloatingActionButton fab;
    protected boolean isRefreshing;
    protected boolean isLoading;
    protected View noResultFound;
    private boolean loading;
    private boolean isLoadMoreEnable = true;
    private boolean isItemDecorationEnable = true;

    @Override
    protected void onViewBind() {
        this.initRecyclerView();
    }

    @Override
    public void initRecyclerView() {
        try {
            if (this.getRecyclerViewId() == 0) {
                throw new RecyclerViewNotFoundException("Recycler View resource id not found");
            }
            this.recyclerView = (RecyclerView)this._findViewById(this.getRecyclerViewId());
            if (this.getProgressBarId() != 0) {
                this.progressBar = (ProgressBar)this._findViewById(this.getProgressBarId());
            }
            if (this.getFabId() != 0) {
                this.fab = (FloatingActionButton)this._findViewById(this.getFabId());
                this.recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new RecyclerScrollListener());
            }
            this.recyclerView.setVisibility(0);
            this.recyclerView.setLayoutManager(this.getLayoutManager());
            if (this.getItemDecoration() != null) {
                this.recyclerView.addItemDecoration(this.getItemDecoration());
            }
            this.recyclerView.setAdapter(this.getRecyclerAdapter());
            if (this.getRefreshLayoutId() != 0) {
                this.refreshLayout = (SwipeRefreshLayout)this._findViewById(this.getRefreshLayoutId());
                if (this.getRefreshListener() != null) {
                    this.refreshLayout.setOnRefreshListener(this.getRefreshListener());
                }
                this.enableSwipeRefreshLayout(false);
            }
            this.onRecyclerViewAttached();
        }
        catch (RecyclerViewNotFoundException e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    private int getFabId() {
        return 0;
    }

    @Override
    public <T extends RecyclerView.Adapter<RecyclerView.ViewHolder>> void bindAdapter(T adapter) {
        this.recyclerView.setAdapter(adapter);
    }

    public void notifyAdapter() {
        this.recyclerView.getAdapter().notifyDataSetChanged();
    }

    @Override
    public void enableSwipeRefreshLayout(boolean enable) {
        this.refreshLayout.setEnabled(enable);
        this.refreshLayout.setSaveEnabled(true);
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        this.manager = new LinearLayoutManager((Context)this.mActivity);
        return this.manager;
    }

    @Override
    public int getRefreshLayoutId() {
        return 0;
    }

    @Override
    public int getProgressBarId() {
        return 0;
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    @Override
    public RecyclerView.ItemDecoration getItemDecoration() {
        return null;
    }

    @Override
    public SwipeRefreshLayout.OnRefreshListener getRefreshListener() {
        return null;
    }

    public class RecyclerScrollListener
    extends RecyclerView.OnScrollListener {
        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            if (dy > 0 || dy < 0 && CoreRecyclerViewBaseFragment.this.fab.isShown()) {
                CoreRecyclerViewBaseFragment.this.fab.hide();
            }
            super.onScrolled(recyclerView, dx, dy);
        }

        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            if (newState == 0) {
                CoreRecyclerViewBaseFragment.this.fab.show();
            }
            super.onScrollStateChanged(recyclerView, newState);
        }
    }
}

