/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolution.support.ui.adapter;

import android.content.Context;
import com.xtensolution.support.ui.adapter.BaseRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class BaseSelectedRecyclerViewAdapter<T>
extends BaseRecyclerViewAdapter<T> {
    protected List<T> selectedItems = new ArrayList<T>();

    public BaseSelectedRecyclerViewAdapter(Context context, List<T> objectsList) {
        super(context, objectsList);
    }

    public void toggleSelection(int position) {
        Object item = this.getItem(position);
        this.toggleSelection(item);
    }

    public void toggleSelection(T item) {
        if (this.selectedItems.contains(item)) {
            this.selectedItems.remove(item);
        } else {
            this.selectedItems.add(item);
        }
        this.notifyDataSetChanged();
    }

    public void removeSelection(T item) {
        if (this.selectedItems.contains(item)) {
            this.selectedItems.remove(item);
        }
        this.notifyDataSetChanged();
    }

    public void selectItem(int position) {
        Object item = this.getItem(position);
        this.selectItem(item);
    }

    public void selectItem(T item) {
        if (this.selectedItems.contains(item)) {
            return;
        }
        this.selectedItems.add(item);
        this.notifyDataSetChanged();
    }

    public void selectAllItem() {
        this.selectedItems.clear();
        this.selectedItems.addAll(this.getList());
        this.notifyDataSetChanged();
    }

    public Collection<T> getSelectedItems() {
        return this.selectedItems;
    }

    protected boolean isItemSelected(int position) {
        return !this.selectedItems.isEmpty() && this.selectedItems.contains(this.getItem(position));
    }

    public void clearSelection() {
        this.selectedItems.clear();
        this.notifyDataSetChanged();
    }
}

