/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolution.support.ui.listener;


import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

/**
 * Created by MIT on 01-Nov-17.
 */

public interface RecyclerBinderListener {
    /**
     * Initialization of recycler mContentView
     */
    void initRecyclerView();
    /**
     * To find the recycler mContentView by id,
     * receive from extended mActivity
     * @return
     */
    int getRecyclerViewId();

    /**
     * LayoutManager require to init recycler mContentView,
     * receive from extended mActivity or default
     * @return
     */
    RecyclerView.LayoutManager getLayoutManager();

    /**
     * To display progress on data loading,
     * get progress bar id where it defined into
     * child mContentView
     * @return
     */
    int getProgressBarId();

    /**
     * Option, if require then init to bind with
     * recycler mContentView
     * @return
     */
    RecyclerView.ItemDecoration getItemDecoration();

    /**
     * Bind adapter to recycler mContentView to manipulate the data
     * @param adapter
     * @param <T>
     */
    <T extends RecyclerView.Adapter<RecyclerView.ViewHolder>> void bindAdapter(T adapter);

    /**
     * Swipe to refresh layout find id from child mContentView
     * @return
     */
    int getRefreshLayoutId();

    /**
     * To listen, refresh layout has been swipe,
     * get from child mContentView
     * @return
     */
    SwipeRefreshLayout.OnRefreshListener getRefreshListener();

    /**
     * To enable and disable swipe refresh layout
     * in current mContentView
     */
    void enableSwipeRefreshLayout(boolean enable);

    /**
     * Call this function after recycler mContentView attached
     * into main mContentView
     */
    void onRecyclerViewAttached();

    RecyclerView.Adapter<RecyclerView.ViewHolder> getRecyclerAdapter();
}
