package com.xtensolution.support.ui.holder;

import android.view.View;

import androidx.annotation.NonNull;

public abstract class BaseViewHolder extends BaseRecyclerHolder implements View.OnClickListener {

    public interface ViewHolderClickListener {
        void onViewHolderViewClicked(View view, int position);
    }

    protected ViewHolderClickListener viewHolderClickListener = null;

    public BaseViewHolder(@NonNull View itemView) {
        super(itemView);
    }

    public void setViewClickListener(ViewHolderClickListener holderClickObserver) {
        viewHolderClickListener = holderClickObserver;
    }

    @Override
    public void onClick(View v) {
        if (viewHolderClickListener != null) {
            viewHolderClickListener.onViewHolderViewClicked(v, getAdapterPosition());
        }
    }
}
