/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.utils;

import android.content.Context;
import android.graphics.Rect;
import android.support.annotation.StringRes;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import com.xtensolutions.support.CoreApp;
import com.xtensolutions.support.utils.Toaster;

public class Toaster {
    public static void shortToast(View view, Window window, @StringRes int text) {
        Toast toast = Toaster.makeToast(CoreApp.getInstance().getString(text), 0);
        Rect rect = new Rect();
        window.getDecorView().getWindowVisibleDisplayFrame(rect);
        int[] viewLocation = new int[2];
        view.getLocationInWindow(viewLocation);
        int viewLeft = viewLocation[0] - rect.left;
        int viewTop = viewLocation[1] - rect.top;
        DisplayMetrics metrics = new DisplayMetrics();
        window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)metrics.widthPixels, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)metrics.heightPixels, (int)0);
        toast.getView().measure(widthMeasureSpec, heightMeasureSpec);
        int toastY = viewTop + view.getHeight();
        toast.setGravity(48, 0, toastY);
        toast.show();
    }

    public static void shortToast(@StringRes int text) {
        Toaster.shortToast(CoreApp.getInstance().getString(text));
    }

    public static void shortToast(String text) {
        Toaster.show(text, 0);
    }

    public static void longToast(@StringRes int text) {
        Toaster.longToast(CoreApp.getInstance().getString(text));
    }

    public static void longToast(String text) {
        Toaster.show(text, 1);
    }

    private static Toast makeToast(String text, @ToastLength int length) {
        return Toast.makeText((Context)CoreApp.getInstance(), (CharSequence)text, (int)length);
    }

    private static void show(String text, @ToastLength int length) {
        Toaster.makeToast(text, length).show();
    }
}

