/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import com.xtensolutions.support.CoreApp;

public class ResourceUtils {
    public static String getString(@StringRes int stringId) {
        return CoreApp.getInstance().getString(stringId);
    }

    public static Drawable getDrawable(@DrawableRes int drawableId) {
        return ContextCompat.getDrawable((Context)CoreApp.getInstance().getBaseContext(), (int)drawableId);
    }

    public static int getColor(@ColorRes int colorId) {
        return ContextCompat.getColor((Context)CoreApp.getInstance().getBaseContext(), (int)colorId);
    }

    public static int getDimen(@DimenRes int dimenId) {
        return (int)CoreApp.getInstance().getResources().getDimension(dimenId);
    }

    public static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    public static int pxToDp(int px) {
        return (int)((float)px / Resources.getSystem().getDisplayMetrics().density);
    }

    public static Drawable changeResourceColor(int color, int iconResId) {
        Drawable icon = ResourceUtils.getDrawable(iconResId);
        icon.setColorFilter(ResourceUtils.getColor(color), PorterDuff.Mode.SRC_ATOP);
        return icon;
    }

    public static Drawable changeResourceColor(int color, Drawable iconResId) {
        iconResId.setColorFilter(ResourceUtils.getColor(color), PorterDuff.Mode.SRC_ATOP);
        return iconResId;
    }
}

