/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.support.v4.app.Fragment;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.util.Base64;
import com.xtensolutions.support.CoreApp;
import com.xtensolutions.support.R;
import com.xtensolutions.support.utils.AppLog;
import com.xtensolutions.support.utils.StorageUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;

public class ImageUtils {
    private static final String TAG = ImageUtils.class.getSimpleName();
    public static final int GALLERY_REQUEST_CODE = 183;
    public static final int CAMERA_REQUEST_CODE = 212;
    private static final String CAMERA_FILE_NAME_PREFIX = "CAMERA_";

    private ImageUtils() {
    }

    public static String saveUriToFile(Uri uri) throws Exception {
        ParcelFileDescriptor parcelFileDescriptor = CoreApp.getInstance().getContentResolver().openFileDescriptor(uri, "r");
        FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
        FileInputStream inputStream = new FileInputStream(fileDescriptor);
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        File parentDir = StorageUtils.getAppExternalDataDirectoryFile();
        String fileName = String.valueOf(System.currentTimeMillis()) + ".jpg";
        File resultFile = new File(parentDir, fileName);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(resultFile));
        byte[] buf = new byte[2048];
        try {
            int length;
            while ((length = bis.read(buf)) > 0) {
                bos.write(buf, 0, length);
            }
        }
        catch (Exception e) {
            throw new IOException("Can't save Storage API bitmap to a file!", e);
        }
        finally {
            parcelFileDescriptor.close();
            bis.close();
            bos.close();
        }
        return resultFile.getAbsolutePath();
    }

    public static void startImagePicker(Activity activity) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        activity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)activity.getString(R.string.dlg_choose_image_from)), 183);
    }

    public static void startImagePicker(Fragment fragment) {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("image/*");
        fragment.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)fragment.getString(R.string.dlg_choose_image_from)), 183);
    }

    public static void startCameraForResult(Activity activity) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(activity.getPackageManager()) == null) {
            return;
        }
        File photoFile = ImageUtils.getTemporaryCameraFile();
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
        activity.startActivityForResult(intent, 212);
    }

    public static void startCameraForResult(Fragment fragment) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (intent.resolveActivity(CoreApp.getInstance().getPackageManager()) == null) {
            return;
        }
        File photoFile = ImageUtils.getTemporaryCameraFile();
        intent.putExtra("output", (Parcelable)Uri.fromFile((File)photoFile));
        fragment.startActivityForResult(intent, 212);
    }

    public static File getTemporaryCameraFile() {
        File storageDir = StorageUtils.getAppExternalDataDirectoryFile();
        File file = new File(storageDir, ImageUtils.getTemporaryCameraFileName());
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    public static File getLastUsedCameraFile() {
        File dataDir = StorageUtils.getAppExternalDataDirectoryFile();
        File[] files = dataDir.listFiles();
        ArrayList<File> filteredFiles = new ArrayList<File>();
        for (File file : files) {
            if (!file.getName().startsWith(CAMERA_FILE_NAME_PREFIX)) continue;
            filteredFiles.add(file);
        }
        Collections.sort(filteredFiles);
        if (!filteredFiles.isEmpty()) {
            return (File)filteredFiles.get(filteredFiles.size() - 1);
        }
        return null;
    }

    private static String getTemporaryCameraFileName() {
        return CAMERA_FILE_NAME_PREFIX + System.currentTimeMillis() + ".jpg";
    }

    public static byte[] getBytes(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)stream);
        return stream.toByteArray();
    }

    public static Bitmap getImage(byte[] image) {
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length);
    }

    public static Drawable getRoundedDrawable(Context context, int width, int height, Bitmap bmp) {
        Bitmap bitmap = Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)false);
        RoundedBitmapDrawable drawable2 = RoundedBitmapDrawableFactory.create((Resources)context.getResources(), (Bitmap)bitmap);
        drawable2.setCircular(true);
        return drawable2;
    }

    public static Drawable getFileIcon(Context context, String extension) {
        return null;
    }

    public static String convertToBase64(Bitmap bitmap) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            byte[] b = baos.toByteArray();
            return Base64.encodeToString((byte[])b, (int)0);
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
            return "";
        }
    }

    public static Bitmap convertBase64ToBitmap(String base64) {
        try {
            byte[] bytarray = Base64.decode((String)base64, (int)0);
            return BitmapFactory.decodeByteArray((byte[])bytarray, (int)0, (int)bytarray.length);
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
            return null;
        }
    }
}

