/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.widget.Toast;
import com.xtensolutions.support.CoreApp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ImagePickerDialog {
    private static final String TAG = ImagePickerDialog.class.getSimpleName();
    private static final int SELECT_FILE = 102;
    private static final int REQUEST_CAMERA = 103;
    private static final int REQUEST_CROP = 101;
    private Activity mActivity;
    private File mTempFile;
    private File mFileTemp;
    private Bitmap mBitmapProfile;
    private static String TEMP_PHOTO_FILE_NAME = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss").format(new Date()) + ".jpg";
    private Uri mURI;
    private ImagePickerListener mListener;
    private String mCurrentPhotoPath;
    private String mIMG_FILE_NAME = "";
    private File directory;

    public ImagePickerDialog(Activity activity, ImagePickerListener listener) {
        this.mActivity = activity;
        this.mListener = listener;
        String state = Environment.getExternalStorageState();
        this.directory = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/" + CoreApp.getInstance().getPackageName());
        if (!this.directory.exists()) {
            this.directory.mkdir();
        }
        this.mFileTemp = "mounted".equals(state) ? new File(Environment.getExternalStorageDirectory(), TEMP_PHOTO_FILE_NAME) : new File(this.mActivity.getFilesDir(), TEMP_PHOTO_FILE_NAME);
    }

    public String getPath(Uri uri) {
        String[] projection = new String[]{"_data"};
        Cursor cursor = this.mActivity.getContentResolver().query(uri, projection, null, null, null);
        int column_index = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        return cursor.getString(column_index);
    }

    public void shareFile() {
        try {
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... params) {
                    return null;
                }

                protected void onPostExecute(Void result) {
                    super.onPostExecute((Object)result);
                }
            }.execute((Object[])new Void[0]);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
    }

    private Uri saveInSdcard() {
        Uri uri = null;
        FileOutputStream fo = null;
        try {
            this.mTempFile = new File(this.directory, System.currentTimeMillis() + ".jpg");
            fo = new FileOutputStream(this.mTempFile);
            this.mBitmapProfile.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)fo);
            fo.flush();
            fo.close();
            MediaStore.Images.Media.insertImage((ContentResolver)this.mActivity.getContentResolver(), (String)this.mTempFile.getAbsolutePath(), (String)this.mTempFile.getName(), (String)this.mTempFile.getName());
            uri = Uri.fromFile((File)this.mTempFile);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        return uri;
    }

    private Bitmap getMutableBitmap(Bitmap bitmap) {
        try {
            Bitmap mutBmp = bitmap.copy(Bitmap.Config.ARGB_8888, true);
            Canvas can = new Canvas(mutBmp);
            can.drawBitmap(bitmap, 0.0f, 0.0f, new Paint());
            return mutBmp;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void openImagePickedFromDialog() {
        final CharSequence[] items = new CharSequence[]{"Take Photo", "Choose from Gallery", "Cancel"};
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity);
        builder.setTitle((CharSequence)"Choose Option");
        builder.setItems(items, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int item) {
                if (items[item].equals("Take Photo")) {
                    ImagePickerDialog.this.openCamera();
                } else if (items[item].equals("Choose from Gallery")) {
                    ImagePickerDialog.this.openGallery();
                } else if (items[item].equals("Cancel")) {
                    dialog.dismiss();
                }
            }
        });
        builder.show();
    }

    public void openGallery() {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        if (Build.VERSION.SDK_INT >= 18) {
            intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
        }
        this.mActivity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select File"), 102);
    }

    public void openCamera() {
        Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (Build.VERSION.SDK_INT == 24) {
            cameraIntent.setFlags(1);
            try {
                this.mURI = FileProvider.getUriForFile((Context)CoreApp.getInstance().getApplicationContext(), (String)"com.xtensolutions.support.provider", (File)this.createImageFile());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            cameraIntent.putExtra("output", (Parcelable)this.mURI);
        } else {
            try {
                File f = this.createImageFile();
                this.mURI = Uri.fromFile((File)f);
                cameraIntent.putExtra("output", (Parcelable)Uri.fromFile((File)f));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.mActivity.startActivityForResult(cameraIntent, 103);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (resultCode == -1) {
            File f = new File(Environment.getExternalStorageDirectory().toString());
            if (requestCode == 103) {
                Log.d((String)TAG, (String)this.mCurrentPhotoPath);
                for (File temp : f.listFiles()) {
                    if (!temp.getName().equals(this.mIMG_FILE_NAME)) continue;
                    this.mFileTemp = temp;
                    break;
                }
                this.mBitmapProfile = BitmapFactory.decodeFile((String)this.mCurrentPhotoPath);
                Uri uri = this.saveInSdcard();
                this.mListener.getBitmapImageFromPhone(this.mTempFile, uri);
                f.delete();
            } else if (requestCode == 102) {
                try {
                    this.mBitmapProfile = MediaStore.Images.Media.getBitmap((ContentResolver)this.mActivity.getContentResolver(), (Uri)data.getData());
                    this.saveInSdcard();
                    this.mListener.getBitmapImageFromPhone(this.mTempFile, data.getData());
                    f.delete();
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
            } else {
                Toast.makeText((Context)this.mActivity, (CharSequence)"Something going to wrong.Try again later.", (int)1).show();
                Log.e((String)TAG, (String)"error in pic...");
            }
        }
    }

    public static void copyStream(InputStream is, OutputStream os) {
        int buffer_size = 1024;
        try {
            int count;
            byte[] bytes = new byte[1024];
            while ((count = is.read(bytes, 0, 1024)) != -1) {
                os.write(bytes, 0, count);
            }
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public void getImagesFrom(int type) {
        if (type == 0) {
            Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
            File f = new File(Environment.getExternalStorageDirectory(), TEMP_PHOTO_FILE_NAME);
            intent.putExtra("output", (Parcelable)Uri.fromFile((File)f));
            this.mActivity.startActivityForResult(intent, 103);
        } else if (type == 1) {
            Intent intent = new Intent("android.intent.action.PICK");
            intent.setType("image/*");
            this.mActivity.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Select File"), 102);
        }
    }

    public String getPath() {
        String path = "";
        if (this.mFileTemp != null) {
            path = this.mFileTemp.getPath();
        }
        return path;
    }

    public Bitmap getBitmapFromFile(File file) {
        if (file != null) {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            Bitmap bitmap = BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
            return bitmap;
        }
        return null;
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        this.mIMG_FILE_NAME = "Img_" + timeStamp + ".jpg";
        File file = new File(this.directory, this.mIMG_FILE_NAME);
        this.mCurrentPhotoPath = file.getAbsolutePath();
        return file;
    }

    public static interface ImagePickerListener {
        public void getBitmapImageFromPhone(File var1, Uri var2);
    }
}

