/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.v7.app.AppCompatActivity;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.xtensolutions.support.CoreApp;
import com.xtensolutions.support.utils.AppLog;

public class DeviceUtils {
    private static final String TAG = DeviceUtils.class.getSimpleName();

    @SuppressLint(value={"MissingPermission"})
    public static String getDeviceUid() {
        String uniqueDeviceId = null;
        try {
            CoreApp context = CoreApp.getInstance();
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            uniqueDeviceId = telephonyManager.getDeviceId();
            if (TextUtils.isEmpty((CharSequence)uniqueDeviceId)) {
                ContentResolver cr = context.getContentResolver();
                uniqueDeviceId = Settings.Secure.getString((ContentResolver)cr, (String)"android_id");
            }
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
        return uniqueDeviceId;
    }

    public static int[] getDeviceSize(Context context) {
        DisplayMetrics metrics = DeviceUtils.getDisplayMetrics(context);
        return new int[]{metrics.widthPixels, metrics.heightPixels};
    }

    public static int getDeviceWidth(Context context) {
        return DeviceUtils.getDisplayMetrics((Context)context).widthPixels;
    }

    public static int getDeviceHeight(Context context) {
        return DeviceUtils.getDisplayMetrics((Context)context).heightPixels;
    }

    private static DisplayMetrics getDisplayMetrics(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        AppCompatActivity activity = (AppCompatActivity)context;
        activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics;
    }
}

