/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.xtensolutions.support.ui.activity.CoreBaseActivity;
import com.xtensolutions.support.ui.activity.CoreDrawerActivity;
import com.xtensolutions.support.ui.listener.MenuCheckedListener;
import com.xtensolutions.support.utils.AppLog;

public abstract class CoreBaseFragment
extends Fragment
implements MenuCheckedListener {
    private static final String TAG = CoreBaseFragment.class.getSimpleName();
    protected CoreBaseActivity mActivity;
    protected View mContentView;
    protected boolean mHasArrow = false;
    protected boolean mHasHamburger = true;
    private OnFragmentInteractionListener mListener;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mContentView = inflater.inflate(this.getViewResourceId(), null, false);
        this.mActivity = (CoreBaseActivity)this.getActivity();
        this.setHasOptionsMenu(true);
        this.onViewBind();
        return this.mContentView;
    }

    public void onResume() {
        this.mActivity.setActionBarTitle(this.getScreenTitle());
        this.changeDrawerIconState();
        super.onResume();
    }

    public void setScreenTitle(String title) {
        this.mActivity.setActionBarTitle(title);
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    public <T extends View> T _findViewById(int resId) {
        return (T)this.mContentView.findViewById(resId);
    }

    protected abstract String getScreenTitle();

    protected abstract int getViewResourceId();

    protected abstract void onViewBind();

    private void changeDrawerIconState() {
        AppLog.d(TAG, "changeDrawerIconState: ");
        if (this.getActivity() instanceof CoreDrawerActivity) {
            CoreDrawerActivity activity = (CoreDrawerActivity)this.getActivity();
            activity.changeDrawerIndicator(this.mHasArrow, this.mHasHamburger);
        }
    }

    @Override
    public int getPageMenuId() {
        return 0;
    }

    public void replaceFragment(Fragment fragment) {
        this.mActivity.replaceFragment(fragment);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof OnFragmentInteractionListener) {
            this.mListener = (OnFragmentInteractionListener)context;
        }
    }

    @Override
    public boolean isHomePage() {
        return false;
    }

    public static interface OnFragmentInteractionListener<T> {
        public void onFragmentInteraction(T var1);
    }
}

