/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.ui.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.xtensolutions.support.R;
import com.xtensolutions.support.utils.AppLog;
import com.xtensolutions.support.utils.ResourceUtils;

public class DividerItemDecoration
extends RecyclerView.ItemDecoration {
    private static final String TAG = DividerItemDecoration.class.getSimpleName();
    private static final int[] ATTRS = new int[]{16843284};
    public static final int HORIZONTAL_LIST = 0;
    public static final int VERTICAL_LIST = 1;
    private Drawable mDivider = ResourceUtils.getDrawable(R.drawable.item_divider);
    private int leftOffset = 0;
    private int mOrientation;

    public DividerItemDecoration(Context context, int orientation, int leftOffset) {
        this.leftOffset = leftOffset;
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        try {
            int right = parent.getWidth() - parent.getPaddingRight();
            int childCount = parent.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = parent.getChildAt(i);
                RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
                int top = child.getBottom() + params.bottomMargin;
                int bottom = top + this.mDivider.getIntrinsicHeight();
                this.mDivider.setBounds(this.leftOffset, top, right, bottom);
                this.mDivider.draw(c);
            }
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }
}

