/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.ui.activity;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.widget.ProgressBar;
import com.xtensolutions.support.exceptions.RecyclerViewNotFoundException;
import com.xtensolutions.support.ui.activity.CoreActionBarActivity;
import com.xtensolutions.support.ui.listener.RecyclerBinderListener;

public abstract class CoreRecyclerActivity
extends CoreActionBarActivity
implements RecyclerBinderListener {
    protected RecyclerView recyclerView;
    protected ProgressBar progressBar;
    protected SwipeRefreshLayout refreshLayout;

    @Override
    protected void onActionBarAttached() {
        this.initRecyclerView();
    }

    @Override
    public void initRecyclerView() {
        if (this.getRecyclerViewId() == 0) {
            throw new RecyclerViewNotFoundException("Recycler View resource id not found");
        }
        this.recyclerView = (RecyclerView)this._findViewById(this.getRecyclerViewId());
        if (this.getProgressBarId() != 0) {
            this.progressBar = (ProgressBar)this._findViewById(this.getProgressBarId());
        }
        this.recyclerView.setVisibility(0);
        this.recyclerView.setLayoutManager(this.getLayoutManager());
        if (this.getItemDecoration() != null) {
            this.recyclerView.addItemDecoration(this.getItemDecoration());
        }
        if (this.getRefreshLayoutId() != 0) {
            this.refreshLayout = (SwipeRefreshLayout)this._findViewById(this.getRefreshLayoutId());
            this.refreshLayout.setOnRefreshListener(this.getRefreshListener());
            this.enableSwipeRefreshLayout(false);
        }
        this.recyclerView.setAdapter(this.getRecyclerAdapter());
        this.onRecyclerViewAttached();
    }

    @Override
    public <T extends RecyclerView.Adapter<RecyclerView.ViewHolder>> void bindAdapter(T adapter) {
        this.recyclerView.setAdapter(adapter);
    }

    @Override
    public RecyclerView.LayoutManager getLayoutManager() {
        return new LinearLayoutManager((Context)this);
    }

    @Override
    public void enableSwipeRefreshLayout(boolean enable) {
        this.refreshLayout.setEnabled(enable);
        this.refreshLayout.setSaveEnabled(true);
    }

    @Override
    public int getRefreshLayoutId() {
        return 0;
    }

    @Override
    public int getProgressBarId() {
        return 0;
    }

    @Override
    public RecyclerView.ItemDecoration getItemDecoration() {
        return null;
    }

    @Override
    public SwipeRefreshLayout.OnRefreshListener getRefreshListener() {
        return null;
    }
}

