/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.ui.activity;

import android.animation.ObjectAnimator;
import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.design.widget.NavigationView;
import android.support.v4.app.Fragment;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.view.MenuItem;
import android.view.View;
import com.xtensolutions.support.R;
import com.xtensolutions.support.ui.activity.CoreActionBarActivity;
import com.xtensolutions.support.ui.listener.MenuCheckedListener;
import com.xtensolutions.support.utils.AppLog;

public abstract class CoreDrawerActivity
extends CoreActionBarActivity
implements NavigationView.OnNavigationItemSelectedListener,
MenuCheckedListener {
    private static final String TAG = CoreDrawerActivity.class.getSimpleName();
    protected ActionBarDrawerToggle mToggle;
    private boolean hasArrow;
    protected NavigationView mNavigationView;
    protected DrawerLayout mDrawerLayout;

    @Override
    protected void onActionBarAttached() {
        this.initDrawer(this.getDrawerLayoutId());
        this.initNavigation(this.getNavigationViewId());
        this.onDrawerAttached();
    }

    private void initDrawer(int drawerId) {
        this.mDrawerLayout = (DrawerLayout)this._findViewById(drawerId);
        this.mToggle = new ActionBarDrawerToggle((Activity)this, this.mDrawerLayout, this.mToolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);
        this.mDrawerLayout.addDrawerListener((DrawerLayout.DrawerListener)this.mToggle);
        this.mToggle.syncState();
    }

    private void initNavigation(int navigationViewId) {
        this.mNavigationView = (NavigationView)this._findViewById(navigationViewId);
        this.mNavigationView.setNavigationItemSelectedListener((NavigationView.OnNavigationItemSelectedListener)this);
    }

    public void changeDrawerIndicator(boolean arrow, boolean hamburger) {
        try {
            if (this.hasArrow != arrow) {
                boolean start = !hamburger;
                this.hasArrow = arrow;
                int drawerLockMode = hamburger ? 0 : 1;
                this.mDrawerLayout.setDrawerLockMode(drawerLockMode);
                ObjectAnimator.ofFloat((Object)this.mToggle.getDrawerArrowDrawable(), (String)"progress", (float[])new float[]{(float)start}).start();
                this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (CoreDrawerActivity.this.hasArrow) {
                            CoreDrawerActivity.this.onBackPressed();
                        } else {
                            CoreDrawerActivity.this.mDrawerLayout.openDrawer(0x800003, true);
                        }
                    }
                });
                this.mToggle.syncState();
                this.changeSelectedMenu();
            }
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected void closeDrawer(int gravity) {
        this.mDrawerLayout.closeDrawer(gravity);
    }

    public void onBackPressed() {
        try {
            AppLog.d(TAG, "onBackPressed: ");
            if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
                AppLog.d(TAG, "onBackPressed: isDrawerOpen :: START");
                this.closeDrawer(0x800003);
            } else if (this.mDrawerLayout.isDrawerOpen(0x800005)) {
                AppLog.d(TAG, "onBackPressed: isDrawerOpen :: END");
                this.closeDrawer(0x800005);
            } else {
                AppLog.d(TAG, "onBackPressed: else");
                this.changeSelectedMenu();
                this.changeHomeFragmentHomeIconState();
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected abstract int getDrawerLayoutId();

    protected abstract int getNavigationViewId();

    protected abstract void onDrawerAttached();

    @Override
    protected void changeSelectedMenu() {
        block6: {
            try {
                if (this.mNavigationView == null) break block6;
                int checkedMenuId = this.getPageMenuId();
                if (this.getFragmentContainer() != 0) {
                    Fragment currentFragment = this.getSupportFragmentManager().findFragmentById(this.getFragmentContainer());
                    try {
                        AppLog.d(TAG, "changeSelectedMenu");
                        if (currentFragment != null && currentFragment instanceof MenuCheckedListener) {
                            MenuCheckedListener listener = (MenuCheckedListener)currentFragment;
                            checkedMenuId = listener.getPageMenuId();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                AppLog.d(TAG, "changeSelectedMenu::" + checkedMenuId);
                this.mNavigationView.setCheckedItem(checkedMenuId);
            }
            catch (Exception e) {
                AppLog.e(TAG, e.getMessage(), e);
            }
        }
    }

    @Override
    protected void onResume() {
        this.changeSelectedMenu();
        super.onResume();
    }

    private void changeHomeFragmentHomeIconState() {
        int backStackCount = this.getSupportFragmentManager().getBackStackEntryCount();
        AppLog.d(TAG, "changeHomeFragmentHomeIconState: backStackCount::" + backStackCount);
        if (backStackCount == 1) {
            this.changeDrawerIndicator(false, true);
        }
    }

    @Override
    public boolean isHomePage() {
        return false;
    }

    @Override
    public int getPageMenuId() {
        return 0;
    }

    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        return true;
    }
}

