/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.ui.activity;

import android.os.Bundle;
import android.support.annotation.StringRes;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.MenuItem;
import android.view.View;
import android.widget.ProgressBar;
import com.xtensolutions.support.R;
import com.xtensolutions.support.exceptions.FragmentContainerResourceNotFoundException;
import com.xtensolutions.support.ui.fragment.CoreBaseFragment;
import com.xtensolutions.support.utils.AppLog;
import com.xtensolutions.support.utils.ErrorUtils;
import com.xtensolutions.support.utils.ResourceUtils;

public abstract class CoreBaseActivity
extends AppCompatActivity {
    private static final String TAG = CoreBaseActivity.class.getSimpleName();
    protected ActionBar mActionBar;
    protected ProgressBar progressBar;
    protected FloatingActionButton fab;
    protected Fragment currentLoadedFragment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getLayout());
        if (this.getProgressBarId() != 0) {
            this.progressBar = (ProgressBar)this._findViewById(this.getProgressBarId());
        }
        if (this.getFabId() != 0) {
            this.fab = (FloatingActionButton)this._findViewById(this.getFabId());
            this.fab.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    CoreBaseActivity.this.onFabClick(view);
                }
            });
        }
        this.onContentViewBind();
    }

    protected void onFabClick(View view) {
        this.showSnackbar(R.string.fab_clicked, new View.OnClickListener(){

            public void onClick(View view) {
            }
        });
    }

    protected int getFabId() {
        return 0;
    }

    protected void onResume() {
        super.onResume();
        this.setActionBarTitle(this.getScreenTitle());
    }

    public <T extends View> T _findViewById(int viewId) {
        return (T)this.findViewById(viewId);
    }

    public void setActionBarTitle(int title) {
        if (this.mActionBar != null) {
            this.mActionBar.setTitle(title);
        }
    }

    public void setActionBarTitle(CharSequence title) {
        if (this.mActionBar != null) {
            this.mActionBar.setTitle(title);
        }
    }

    protected void showSnackbarError(@StringRes int resId, Exception e, View.OnClickListener clickListener) {
        ErrorUtils.showSnackbar(this.getRootView(), resId, e, R.string.dlg_retry, clickListener);
    }

    protected abstract String getScreenTitle();

    protected abstract int getLayout();

    public abstract View getRootView();

    protected abstract void onContentViewBind();

    protected void setHomeButtonEnable(boolean enable) {
        if (this.mActionBar != null) {
            this.mActionBar.setHomeButtonEnabled(enable);
            this.mActionBar.setDisplayHomeAsUpEnabled(enable);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
        }
        return super.onOptionsItemSelected(item);
    }

    public int getProgressBarId() {
        return 0;
    }

    public void replaceFragment(Fragment fragment) {
        try {
            CoreBaseFragment baseFragment;
            if (fragment instanceof CoreBaseFragment && (baseFragment = (CoreBaseFragment)fragment).isHomePage()) {
                this.onBackPressed();
                return;
            }
            if (this.getFragmentContainer() != 0) {
                this.currentLoadedFragment = this.getSupportFragmentManager().findFragmentById(this.getFragmentContainer());
                if (this.currentLoadedFragment != null && this.currentLoadedFragment.getTag() != null) {
                    String tag = fragment.getClass().getSimpleName();
                    if (this.currentLoadedFragment.getTag().equalsIgnoreCase(tag)) {
                        return;
                    }
                }
            } else {
                throw new FragmentContainerResourceNotFoundException(ResourceUtils.getString(R.string.no_fragment_container_found));
            }
            FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
            ft.replace(this.getFragmentContainer(), fragment, fragment.getClass().getSimpleName());
            ft.setTransition(4096);
            ft.addToBackStack(fragment.getClass().getSimpleName());
            ft.commit();
        }
        catch (Exception e) {
            AppLog.e(TAG, e.getMessage(), e);
        }
    }

    protected int getFragmentContainer() {
        return 0;
    }

    protected void changeSelectedMenu() {
    }

    public void showSnackbar(@StringRes int resId, View.OnClickListener listener) {
        ErrorUtils.showSnackbar(this.getRootView(), resId, R.string.dlg_ok, listener);
    }
}

