/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.builder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeConverter {
    private int hours;
    private int minutes;
    private int seconds;
    private long milliseconds;
    private int days;
    private int weeks;
    private int months;
    private int years;
    private String dayOfWeek;
    private String monthOfYear;
    private int monthInDate;
    private int yearInDate;

    private DateTimeConverter() {
    }

    public int getHours() {
        return this.hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public int getDays() {
        return this.days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public void setWeeks(int weeks) {
        this.weeks = weeks;
    }

    public int getMonths() {
        return this.months;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public int getYears() {
        return this.years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getMonthOfYear() {
        return this.monthOfYear;
    }

    public void setMonthOfYear(String monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    public int getMonthInDate() {
        return this.monthInDate;
    }

    public void setMonthInDate(int monthInDate) {
        this.monthInDate = monthInDate;
    }

    public int getYearInDate() {
        return this.yearInDate;
    }

    public void setYearInDate(int yearInDate) {
        this.yearInDate = yearInDate;
    }

    public static class Builder {
        private String format = "yyyy-mm-dd HH:mm:ss";
        private Date from;
        private Date to;
        private SimpleDateFormat sdf;
        private TimeZone timeZone = TimeZone.getDefault();
        private DateTimeConverter converter;

        public Builder() {
            this.setFormat();
            this.converter = new DateTimeConverter();
        }

        private void setFormat() {
            this.sdf = new SimpleDateFormat(this.format);
            this.sdf.setTimeZone(this.timeZone);
        }

        public Builder format(String format) {
            this.format = format;
            this.setFormat();
            return this;
        }

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder from(String from) throws ParseException {
            this.from = this.sdf.parse(from);
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }

        public Builder to(String to) throws ParseException {
            this.to = this.sdf.parse(to);
            return this;
        }

        public DateTimeConverter build() {
            try {
                long milliseconds = this.getDifferenceInMilli();
                this.converter.setMilliseconds(milliseconds);
                long seconds = milliseconds / 1000L;
                this.converter.setSeconds((int)seconds);
                int minutes = (int)(seconds / 60L);
                this.converter.setMinutes(minutes);
                int hours = minutes / 60;
                this.converter.setHours(hours);
                int days = hours / 24;
                this.converter.setDays(days);
                int weeks = days / 7;
                this.converter.setWeeks(weeks);
                int months = days / 30;
                this.converter.setMonths(months);
                int years = days / 365;
                this.converter.setYears(years);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.converter;
        }

        private long getDifferenceInMilli() {
            if (this.from != null && this.to != null) {
                return this.to.getTime() - this.from.getTime();
            }
            if (this.from != null) {
                return System.currentTimeMillis() - this.from.getTime();
            }
            if (this.to != null) {
                return this.to.getTime() - System.currentTimeMillis();
            }
            return System.currentTimeMillis();
        }
    }
}

