/*
 * Decompiled with CFR 0.152.
 */
package com.xtensolutions.support.async;

import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;

public abstract class BaseAsyncTask<Params, Progress, Result>
extends AsyncTask<Params, Progress, Result> {
    private static final String TAG = BaseAsyncTask.class.getSimpleName();
    private static final Handler mainThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isExceptionOccurred;

    protected final Result doInBackground(Params ... params) {
        try {
            return this.performInBackground(params);
        }
        catch (Exception e) {
            this.isExceptionOccurred = true;
            mainThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    BaseAsyncTask.this.onException(e);
                }
            });
            return null;
        }
    }

    protected final void onPostExecute(Result result) {
        if (!this.isExceptionOccurred) {
            this.onResult(result);
        }
    }

    public abstract Result performInBackground(Params ... var1) throws Exception;

    public abstract void onResult(Result var1);

    public void onException(Exception e) {
        Log.w((String)TAG, (Throwable)e);
    }
}

