/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.ui.listener;

import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;

/**
 * Created by MIT on 01-Nov-17.
 */

public interface RecyclerBinderListener {
    /**
     * Initialization
     */
    void initRecyclerView();
    /**
     * To find the recycler by id,
     * receive from extended Activity
     * @return int recyclerView resource id
     */
    int getRecyclerViewId();

    /**
     * LayoutManager require to init recycler view,
     * receive from extended mActivity or default
     * @return RecyclerView.LayoutManager
     */
    RecyclerView.LayoutManager getLayoutManager();

    /**
     * To display progress on data loading,
     * get progress bar id where it defined
     * @return int progress bar resource id
     */

    int getProgressBarId();

    /**
     * Option, if require then init to bind with
     * recycler view
     * @return RecyclerView.ItemDecoration
     */
    RecyclerView.ItemDecoration getItemDecoration();

    /**
     * Bind adapter to recycler mContentView to manipulate the data
     * @param adapter
     * @param <T>
     */
    <T extends RecyclerView.Adapter<RecyclerView.ViewHolder>> void bindAdapter(T adapter);

    /**
     * Swipe to refresh layout find id from child view
     * @return Refresh Layout resource id
     */
    int getRefreshLayoutId();

    /**
     * To listen, refresh layout has been swipe,
     * get from child view
     * @return SwipeRefreshLayout.OnRefreshListener
     */
    SwipeRefreshLayout.OnRefreshListener getRefreshListener();

    /**
     * To enable and disable swipe refresh layout
     * in current view
     */
    void enableSwipeRefreshLayout(boolean enable);

    /**
     * Call this function after recycler mContentView attached
     * into main view
     */
    void onRecyclerViewAttached();

    RecyclerView.Adapter<RecyclerView.ViewHolder> getRecyclerAdapter();
}
