/*
 * Copyright (c) 2016 riontech-xten
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.xtensolutions.support.builder;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

/**
 * Created by Riontech
 * Vaghela Mithun R.
 * vaghela.mithun@gmail.com,
 * 9727206702
 * on 02-Jan-18.
 */

/**
 * A simple class to handle the date and time
 * related function like, da
 * Contain method return the result after the completed
 * the background process
 */

public class DateTimeConverter {
    private int hours;
    private int minutes;
    private int seconds;
    private long milliseconds;
    private int days;
    private int weeks;
    private int months;
    private int years;
    private String dayOfWeek;
    private String monthOfYear;
    private int monthInDate;
    private int yearInDate;

    private DateTimeConverter() {
    }

    public int getHours() {
        return hours;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getMinutes() {
        return minutes;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public int getSeconds() {
        return seconds;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public long getMilliseconds() {
        return milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public int getDays() {
        return days;
    }

    public void setDays(int days) {
        this.days = days;
    }

    public int getWeeks() {
        return weeks;
    }

    public void setWeeks(int weeks) {
        this.weeks = weeks;
    }

    public int getMonths() {
        return months;
    }

    public void setMonths(int months) {
        this.months = months;
    }

    public int getYears() {
        return years;
    }

    public void setYears(int years) {
        this.years = years;
    }

    public String getDayOfWeek() {
        return dayOfWeek;
    }

    public void setDayOfWeek(String dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public String getMonthOfYear() {
        return monthOfYear;
    }

    public void setMonthOfYear(String monthOfYear) {
        this.monthOfYear = monthOfYear;
    }

    public int getMonthInDate() {
        return monthInDate;
    }

    public void setMonthInDate(int monthInDate) {
        this.monthInDate = monthInDate;
    }

    public int getYearInDate() {
        return yearInDate;
    }

    public void setYearInDate(int yearInDate) {
        this.yearInDate = yearInDate;
    }

    public static class Builder {
        private String format = "yyyy-mm-dd HH:mm:ss";
        private Date from;
        private Date to;
        private SimpleDateFormat sdf;
        private TimeZone timeZone = TimeZone.getDefault();
        private DateTimeConverter converter;

        //        private Date
        public Builder() {
            setFormat();
            converter = new DateTimeConverter();
        }

        private void setFormat() {
            sdf = new SimpleDateFormat(format);
            sdf.setTimeZone(timeZone);
        }

        public Builder format(String format) {
            this.format = format;
            setFormat();
            return this;
        }

        public Builder from(Date from) {
            this.from = from;
            return this;
        }

        public Builder from(String from) throws ParseException {
            this.from = sdf.parse(from);
            return this;
        }

        public Builder to(Date to) {
            this.to = to;
            return this;
        }

        public Builder to(String to) throws ParseException {
            this.to = sdf.parse(to);
            return this;
        }

        public DateTimeConverter build() {
            try {
                long milliseconds = getDifferenceInMilli();
                converter.setMilliseconds(milliseconds);

//              convert into seconds
                long seconds = milliseconds / 1000;
                converter.setSeconds((int) seconds);

//              convert into minutes
                int minutes = (int) (seconds / 60);
                converter.setMinutes(minutes);

//              convert into hours
                int hours = minutes / 60;
                converter.setHours(hours);

//              convert into days
                int days = hours / 24;
                converter.setDays(days);

//              convert into weeks
                int weeks = days / 7;
                converter.setWeeks(weeks);

//              convert into month
                int months = days / 30;
                converter.setMonths(months);

//              convert into years
                int years = days / 365;
                converter.setYears(years);
            } catch (Exception e) {
                e.printStackTrace();
            }

            return converter;
        }

        private long getDifferenceInMilli() {
            if (from != null && to != null) {
                return to.getTime() - from.getTime();
            } else if (from != null) {
                return System.currentTimeMillis() - from.getTime();
            } else if (to != null) {
                return to.getTime() - System.currentTimeMillis();
            } else {
                return System.currentTimeMillis();
            }
        }

    }
}
