/*
 * Decompiled with CFR 0.152.
 */
package com.xkcoding.http.util;

import cn.hutool.core.exceptions.UtilException;
import com.xkcoding.http.constants.Constants;
import com.xkcoding.http.exception.SimpleHttpException;
import com.xkcoding.http.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public final class UrlUtil {
    public static String urlEncode(String value) {
        if (value == null) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(value, Constants.DEFAULT_ENCODING.displayName());
            return encoded.replace("+", "%20").replace("*", "%2A").replace("~", "%7E").replace("/", "%2F");
        }
        catch (UnsupportedEncodingException e) {
            throw new SimpleHttpException("Failed To Encode Uri", e);
        }
    }

    public static String urlDecode(String url) throws UtilException {
        if (StringUtil.isEmpty(url)) {
            return url;
        }
        try {
            return URLDecoder.decode(url, Constants.DEFAULT_ENCODING.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new SimpleHttpException("Unsupported encoding", e);
        }
    }

    private UrlUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

