/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.IoUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.HttpException;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpBase;
import com.xiaoleilu.hutool.http.HttpConnection;
import com.xiaoleilu.hutool.http.HttpUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class HttpResponse
extends HttpBase<HttpResponse> {
    private int status;

    public static HttpResponse readResponse(HttpConnection httpConnection) {
        HttpResponse httpResponse = new HttpResponse();
        try {
            httpResponse.status = httpConnection.responseCode();
            httpResponse.headers = httpConnection.headers();
            httpResponse.charset = httpConnection.charset();
            httpResponse.readBody(httpConnection.getInputStream());
        }
        catch (IOException e) {
            throw new HttpException(e.getMessage(), e);
        }
        return httpResponse;
    }

    public int getStatus() {
        return this.status;
    }

    public byte[] bodyBytes() {
        if (this.body == null) {
            return null;
        }
        return StrUtil.bytes(this.body, this.charset);
    }

    public String body() {
        return this.body;
    }

    private void readBody(InputStream in) throws IOException {
        this.body = HttpUtil.getString(in, "UTF-8", this.charset == null);
        this.unzip();
    }

    private HttpResponse unzip() {
        String contentEncoding = this.contentEncoding();
        if (contentEncoding != null && this.contentEncoding().equals("gzip") && this.body != null) {
            this.removeHeader(Header.CONTENT_ENCODING);
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(StrUtil.bytes(this.body, this.charset));
                GZIPInputStream gzipInputStream = new GZIPInputStream(in);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IoUtil.copy(gzipInputStream, out);
                this.body = out.toString(this.charset);
            }
            catch (IOException ioex) {
                throw new HttpException(ioex);
            }
        }
        return this;
    }
}

