/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool;

import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.exceptions.UtilException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class CharsetUtil {
    public static final String ISO_8859_1 = "ISO-8859-1";
    public static final String UTF_8 = "UTF-8";
    public static final String GBK = "GBK";

    private CharsetUtil() {
    }

    public static String convert(String source, String srcCharset, String newCharset) {
        if (StrUtil.isBlank(srcCharset)) {
            srcCharset = ISO_8859_1;
        }
        if (StrUtil.isBlank(newCharset)) {
            srcCharset = UTF_8;
        }
        if (StrUtil.isBlank(source) || srcCharset.equals(newCharset)) {
            return source;
        }
        try {
            return new String(source.getBytes(srcCharset), newCharset);
        }
        catch (UnsupportedEncodingException unex) {
            throw new UtilException(unex);
        }
    }

    @Deprecated
    public static String str(byte[] data, String charset) {
        if (data == null) {
            return null;
        }
        if (StrUtil.isBlank(charset)) {
            return new String(data);
        }
        try {
            return new String(data, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilException(e);
        }
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        Charset cs = StrUtil.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset);
        return cs.decode(data).toString();
    }

    public static ByteBuffer toByteBuffer(String str, String charset) {
        return ByteBuffer.wrap(StrUtil.encode(str, charset));
    }

    public static String systemCharset() {
        String charset = System.getProperty("file.encoding");
        if (StrUtil.isBlank(charset)) {
            charset = UTF_8;
        }
        return charset;
    }
}

