/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.http.Header;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class HttpBase<T> {
    public static final String HTTP_1_0 = "HTTP/1.0";
    public static final String HTTP_1_1 = "HTTP/1.1";
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected String charset;
    protected String httpVersion = "HTTP/1.1";
    protected String mediaType;
    protected String body;

    public String header(String name) {
        if (StrUtil.isBlank(name)) {
            return null;
        }
        List<String> values = this.headers.get(name.trim());
        if (CollectionUtil.isEmpty(values)) {
            return null;
        }
        return values.get(0);
    }

    public String header(Header name) {
        return this.header(name.toString());
    }

    public void removeHeader(String name) {
        if (name != null) {
            this.headers.remove(name.trim());
        }
    }

    public void removeHeader(Header name) {
        this.removeHeader(name.toString());
    }

    public T header(String name, String value, boolean isOverride) {
        if (null != name && null != value) {
            List<String> values = this.headers.get(name.trim());
            if (CollectionUtil.isEmpty(values)) {
                this.headers.put(name.trim(), Arrays.asList(value.trim()));
            } else {
                values.add(value.trim());
            }
        }
        return (T)this;
    }

    public T header(Header name, String value, boolean isOverride) {
        return this.header(name.toString(), value, isOverride);
    }

    public T header(Header name, String value) {
        return this.header(name.toString(), value, true);
    }

    public T header(String name, String value) {
        return this.header(name, value, true);
    }

    public void header(Map<String, List<String>> headers) {
        if (CollectionUtil.isEmpty(headers)) {
            return;
        }
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                this.header(name, StrUtil.nullToEmpty(value), false);
            }
        }
    }

    public Map<String, List<String>> headers() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String httpVersion() {
        return this.httpVersion;
    }

    public T httpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
        return (T)this;
    }

    public String charset() {
        return this.charset;
    }

    public T charset(String charset) {
        this.charset = null;
        this.contentType(null, charset);
        return (T)this;
    }

    public String mediaType() {
        return this.mediaType;
    }

    public T mediaType(String mediaType) {
        this.contentType(mediaType, null);
        return (T)this;
    }

    public String contentType() {
        return this.header(Header.CONTENT_TYPE);
    }

    public T contentType(String contentType) {
        this.header(Header.CONTENT_TYPE, contentType);
        return (T)this;
    }

    public T contentType(String mediaType, String charset) {
        if (StrUtil.isNotBlank(mediaType)) {
            this.mediaType = mediaType;
        }
        if (StrUtil.isNotBlank(charset)) {
            this.charset = charset;
        }
        String contentType = this.mediaType;
        if (this.charset != null) {
            contentType = contentType + ";charset=" + charset;
        }
        return this.contentType(contentType);
    }

    public T keepAlive(boolean isKeepAlive) {
        Header value = isKeepAlive ? Header.KEEP_ALIVE : Header.CLOSE;
        this.header(Header.CONNECTION, value.toString());
        return (T)this;
    }

    public boolean isKeepAlive() {
        String connection = this.header(Header.CONNECTION);
        if (connection == null) {
            return !this.httpVersion.equalsIgnoreCase(HTTP_1_0);
        }
        return !connection.equalsIgnoreCase(Header.CLOSE.toString());
    }

    public String contentLength() {
        return this.header(Header.CONTENT_LENGTH);
    }

    public T contentLength(int value) {
        this.header(Header.CONTENT_LENGTH, String.valueOf(value));
        return (T)this;
    }

    public String contentEncoding() {
        return this.header(Header.CONTENT_ENCODING);
    }

    public String accept() {
        return this.header(Header.ACCEPT);
    }

    public T accept(String accept) {
        this.header(Header.ACCEPT, accept);
        return (T)this;
    }

    public String acceptEncoding() {
        return this.header(Header.ACCEPT_ENCODING);
    }

    public T acceptEncoding(String encodings) {
        this.header(Header.ACCEPT_ENCODING, encodings);
        return (T)this;
    }
}

