/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.db.Condition;
import com.xiaoleilu.hutool.db.Entity;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class Wrapper {
    private char wrapQuote;

    public Wrapper(char wrapQuote) {
        this.wrapQuote = wrapQuote;
    }

    public char getWrapQuote() {
        return this.wrapQuote;
    }

    public void setWrapQuote(char wrapQuote) {
        this.wrapQuote = wrapQuote;
    }

    public String wrap(String field) {
        if (StrUtil.isBlank(field)) {
            return field;
        }
        if (field.contains(String.valueOf(this.wrapQuote))) {
            return field;
        }
        if (field.contains("*") || field.contains("(")) {
            return field;
        }
        return StrUtil.format("{}{}{}", Character.valueOf(this.wrapQuote), field, Character.valueOf(this.wrapQuote));
    }

    public String[] wrap(String ... fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollectionUtil.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[fields.size()])));
    }

    public Entity wrap(Entity entity) {
        if (null == entity) {
            return null;
        }
        Entity wrapedEntity = new Entity();
        wrapedEntity.setTableName(this.wrap(entity.getTableName()));
        for (Map.Entry entry : entity.entrySet()) {
            wrapedEntity.set(this.wrap((String)entry.getKey()), entry.getValue());
        }
        return wrapedEntity;
    }

    public Condition[] wrap(Condition ... conditions) {
        Condition[] clonedConditions = new Condition[conditions.length];
        if (CollectionUtil.isNotEmpty(conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = conditions[i].clone();
                clonedCondition.setField(this.wrap(clonedCondition.getField()));
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }
}

