/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.CollectionUtil;
import com.xiaoleilu.hutool.StrUtil;
import com.xiaoleilu.hutool.db.Condition;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Wrapper;
import com.xiaoleilu.hutool.exceptions.DbRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SqlBuilder {
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> paramValues = new ArrayList<Object>();
    private Wrapper wrapper;

    public static SqlBuilder create() {
        return new SqlBuilder();
    }

    public static SqlBuilder create(Wrapper wrapper) {
        return new SqlBuilder(wrapper);
    }

    public SqlBuilder() {
    }

    public SqlBuilder(Wrapper wrapper) {
        this.wrapper = wrapper;
    }

    public SqlBuilder insert(Entity entity) {
        DbUtil.validateEntity(entity);
        if (null != this.wrapper) {
            entity = this.wrapper.wrap(entity);
        }
        this.sql.append("INSERT INTO ").append(entity.getTableName()).append(" (");
        StringBuilder placeHolder = new StringBuilder(") VALUES (");
        for (Map.Entry entry : entity.entrySet()) {
            if (this.paramValues.size() > 0) {
                this.sql.append(", ");
                placeHolder.append(", ");
            }
            this.sql.append((String)entry.getKey());
            placeHolder.append("?");
            this.paramValues.add(entry.getValue());
        }
        this.sql.append(placeHolder.toString()).append(")");
        return this;
    }

    public SqlBuilder delete(String tableName) {
        if (StrUtil.isBlank(tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append("DELETE FROM ").append(tableName);
        return this;
    }

    public SqlBuilder update(Entity entity) {
        DbUtil.validateEntity(entity);
        if (null != this.wrapper) {
            entity = this.wrapper.wrap(entity);
        }
        this.sql.append("UPDATE ").append(entity.getTableName()).append(" SET ");
        for (Map.Entry entry : entity.entrySet()) {
            if (this.paramValues.size() > 0) {
                this.sql.append(", ");
            }
            this.sql.append((String)entry.getKey()).append(" = ? ");
            this.paramValues.add(entry.getValue());
        }
        return this;
    }

    public SqlBuilder select(boolean isDistinct, String ... fields) {
        return this.select(isDistinct, Arrays.asList(fields));
    }

    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        this.sql.append("SELECT ");
        if (isDistinct) {
            this.sql.append("DISTINCT ");
        }
        if (CollectionUtil.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(CollectionUtil.join(fields, ","));
        }
        return this;
    }

    public SqlBuilder select(String ... fields) {
        return this.select(false, fields);
    }

    public SqlBuilder select(Collection<String> fields) {
        return this.select(false, fields);
    }

    public SqlBuilder from(String ... tableNames) {
        if (CollectionUtil.isEmpty(tableNames) || StrUtil.hasBlank(tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (null != this.wrapper) {
            tableNames = this.wrapper.wrap(tableNames);
        }
        this.sql.append(" FROM ").append(CollectionUtil.join(tableNames, ","));
        return this;
    }

    public SqlBuilder where(LogicalOperator logicalOperator, Condition ... conditions) {
        if (CollectionUtil.isNotEmpty(conditions)) {
            this.sql.append(" WHERE ");
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.sql.append(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public <T> SqlBuilder in(String field, T ... values) {
        this.sql.append(this.wrapper.wrap(field)).append(" IN ").append("(").append(CollectionUtil.join(values, ",")).append(")");
        return this;
    }

    public SqlBuilder groupBy(String ... fields) {
        if (CollectionUtil.isNotEmpty(fields)) {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(CollectionUtil.join(fields, ","));
        }
        return this;
    }

    public SqlBuilder having(LogicalOperator logicalOperator, Condition ... conditions) {
        if (CollectionUtil.isNotEmpty(conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.sql.append(" HAVING ").append(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder orderBy(Order order, String ... fields) {
        if (CollectionUtil.isNotEmpty(fields)) {
            if (null != this.wrapper) {
                fields = this.wrapper.wrap(fields);
            }
            this.sql.append(" ORDER BY ").append(CollectionUtil.join(fields, ",")).append(" ").append(null == order ? "" : order);
        }
        return this;
    }

    public SqlBuilder join(String tableName, Join join) {
        if (StrUtil.isBlank(tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != join) {
            this.sql.append(" ").append((Object)join);
        }
        if (null != this.wrapper) {
            tableName = this.wrapper.wrap(tableName);
        }
        this.sql.append(" JOIN ").append(tableName);
        return this;
    }

    public SqlBuilder on(LogicalOperator logicalOperator, Condition ... conditions) {
        if (CollectionUtil.isNotEmpty(conditions)) {
            if (null != this.wrapper) {
                conditions = this.wrapper.wrap(conditions);
            }
            this.sql.append(" ON ").append(this.buildCondition(logicalOperator, conditions));
        }
        return this;
    }

    public SqlBuilder append(Object sqlPart) {
        if (null != sqlPart) {
            this.sql.append(sqlPart);
        }
        return this;
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[this.paramValues.size()]);
    }

    public String build() {
        return this.sql.toString().trim();
    }

    public String toString() {
        return this.build();
    }

    private String buildCondition(LogicalOperator logicalOperator, Condition ... conditions) {
        if (CollectionUtil.isEmpty(conditions)) {
            return "";
        }
        if (null == logicalOperator) {
            logicalOperator = LogicalOperator.AND;
        }
        StringBuilder conditionStr = new StringBuilder();
        boolean isFirst = true;
        for (Condition condition : conditions) {
            if (isFirst) {
                isFirst = false;
            } else {
                conditionStr.append(" ").append((Object)logicalOperator).append(" ");
            }
            conditionStr.append(condition.getField()).append(" ").append(condition.getOperator());
            if (condition.isPlaceHolder()) {
                conditionStr.append(" ?");
                this.paramValues.add(condition.getValue());
                continue;
            }
            conditionStr.append(condition.getValue());
        }
        return conditionStr.toString();
    }

    public static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }

    public static enum Order {
        ASC,
        DESC;

    }

    public static enum LogicalOperator {
        AND,
        OR;

    }
}

